package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  LocaleId,
  Text,
  BotAliasIdentifier,
  BotIdentifier,
  SessionId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecognizeTextRequest(
    botId: BotIdentifier,
    botAliasId: BotAliasIdentifier,
    localeId: LocaleId,
    sessionId: SessionId,
    text: Text,
    sessionState: Option[zio.aws.lexruntimev2.model.SessionState] = None,
    requestAttributes: Option[Map[NonEmptyString, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest = {
    import RecognizeTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasIdentifier.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .text(Text.unwrap(text): java.lang.String)
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RecognizeTextRequest.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeTextRequest.wrap(buildAwsValue())
}
object RecognizeTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeTextRequest =
      zio.aws.lexruntimev2.model.RecognizeTextRequest(
        botId,
        botAliasId,
        localeId,
        sessionId,
        text,
        sessionState.map(value => value.asEditable),
        requestAttributes.map(value => value)
      )
    def botId: BotIdentifier
    def botAliasId: BotAliasIdentifier
    def localeId: LocaleId
    def sessionId: SessionId
    def text: Text
    def sessionState: Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def requestAttributes: Option[Map[NonEmptyString, String]]
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasIdentifier] =
      ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getText: ZIO[Any, Nothing, Text] = ZIO.succeed(text)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest
  ) extends zio.aws.lexruntimev2.model.RecognizeTextRequest.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botAliasId: BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives
        .BotAliasIdentifier(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexruntimev2.model.primitives.LocaleId(impl.localeId())
    override val sessionId: SessionId =
      zio.aws.lexruntimev2.model.primitives.SessionId(impl.sessionId())
    override val text: Text =
      zio.aws.lexruntimev2.model.primitives.Text(impl.text())
    override val sessionState
        : Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
    override val requestAttributes: Option[Map[NonEmptyString, String]] = scala
      .Option(impl.requestAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest
  ): zio.aws.lexruntimev2.model.RecognizeTextRequest.ReadOnly = new Wrapper(
    impl
  )
}
