package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  SessionId,
  LocaleId,
  BotAliasIdentifier,
  BotIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSessionResponse(
    botId: Option[BotIdentifier] = None,
    botAliasId: Option[BotAliasIdentifier] = None,
    localeId: Option[LocaleId] = None,
    sessionId: Option[SessionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
      .builder()
      .optionallyWith(
        botId.map(value => BotIdentifier.unwrap(value): java.lang.String)
      )(_.botId)
      .optionallyWith(
        botAliasId.map(value =>
          BotAliasIdentifier.unwrap(value): java.lang.String
        )
      )(_.botAliasId)
      .optionallyWith(
        localeId.map(value => LocaleId.unwrap(value): java.lang.String)
      )(_.localeId)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly =
    zio.aws.lexruntimev2.model.DeleteSessionResponse.wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.DeleteSessionResponse =
      zio.aws.lexruntimev2.model.DeleteSessionResponse(
        botId.map(value => value),
        botAliasId.map(value => value),
        localeId.map(value => value),
        sessionId.map(value => value)
      )
    def botId: Option[BotIdentifier]
    def botAliasId: Option[BotAliasIdentifier]
    def localeId: Option[LocaleId]
    def sessionId: Option[SessionId]
    def getBotId: ZIO[Any, AwsError, BotIdentifier] =
      AwsError.unwrapOptionField("botId", botId)
    def getBotAliasId: ZIO[Any, AwsError, BotAliasIdentifier] =
      AwsError.unwrapOptionField("botAliasId", botAliasId)
    def getLocaleId: ZIO[Any, AwsError, LocaleId] =
      AwsError.unwrapOptionField("localeId", localeId)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ) extends zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly {
    override val botId: Option[BotIdentifier] = scala
      .Option(impl.botId())
      .map(value => zio.aws.lexruntimev2.model.primitives.BotIdentifier(value))
    override val botAliasId: Option[BotAliasIdentifier] = scala
      .Option(impl.botAliasId())
      .map(value =>
        zio.aws.lexruntimev2.model.primitives.BotAliasIdentifier(value)
      )
    override val localeId: Option[LocaleId] = scala
      .Option(impl.localeId())
      .map(value => zio.aws.lexruntimev2.model.primitives.LocaleId(value))
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse
  ): zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
