package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{SessionId, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecognizeTextResponse(
    messages: Option[Iterable[zio.aws.lexruntimev2.model.Message]] = None,
    sessionState: Option[zio.aws.lexruntimev2.model.SessionState] = None,
    interpretations: Option[
      Iterable[zio.aws.lexruntimev2.model.Interpretation]
    ] = None,
    requestAttributes: Option[Map[NonEmptyString, String]] = None,
    sessionId: Option[SessionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse = {
    import RecognizeTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
      .builder()
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .optionallyWith(
        interpretations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.interpretations)
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeTextResponse.wrap(buildAwsValue())
}
object RecognizeTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeTextResponse =
      zio.aws.lexruntimev2.model.RecognizeTextResponse(
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionState.map(value => value.asEditable),
        interpretations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requestAttributes.map(value => value),
        sessionId.map(value => value)
      )
    def messages: Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def sessionState: Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def interpretations
        : Option[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]]
    def requestAttributes: Option[Map[NonEmptyString, String]]
    def sessionId: Option[SessionId]
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getInterpretations: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Interpretation.ReadOnly
    ]] = AwsError.unwrapOptionField("interpretations", interpretations)
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ) extends zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly {
    override val messages
        : Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] = scala
      .Option(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntimev2.model.Message.wrap(item)
        }.toList
      )
    override val sessionState
        : Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
    override val interpretations
        : Option[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]] =
      scala
        .Option(impl.interpretations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Interpretation.wrap(item)
          }.toList
        )
    override val requestAttributes: Option[Map[NonEmptyString, String]] = scala
      .Option(impl.requestAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse
  ): zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly = new Wrapper(
    impl
  )
}
