package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Intent(
    name: NonEmptyString,
    slots: Option[Map[NonEmptyString, zio.aws.lexruntimev2.model.Slot]] = None,
    state: Option[zio.aws.lexruntimev2.model.IntentState] = None,
    confirmationState: Option[zio.aws.lexruntimev2.model.ConfirmationState] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.Intent = {
    import Intent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.Intent
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(confirmationState.map(value => value.unwrap))(
        _.confirmationState
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.Intent.ReadOnly =
    zio.aws.lexruntimev2.model.Intent.wrap(buildAwsValue())
}
object Intent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.Intent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.Intent =
      zio.aws.lexruntimev2.model.Intent(
        name,
        slots.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        state.map(value => value),
        confirmationState.map(value => value)
      )
    def name: NonEmptyString
    def slots
        : Option[Map[NonEmptyString, zio.aws.lexruntimev2.model.Slot.ReadOnly]]
    def state: Option[zio.aws.lexruntimev2.model.IntentState]
    def confirmationState: Option[zio.aws.lexruntimev2.model.ConfirmationState]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getSlots: ZIO[Any, AwsError, Map[
      NonEmptyString,
      zio.aws.lexruntimev2.model.Slot.ReadOnly
    ]] = AwsError.unwrapOptionField("slots", slots)
    def getState: ZIO[Any, AwsError, zio.aws.lexruntimev2.model.IntentState] =
      AwsError.unwrapOptionField("state", state)
    def getConfirmationState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.ConfirmationState] =
      AwsError.unwrapOptionField("confirmationState", confirmationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Intent
  ) extends zio.aws.lexruntimev2.model.Intent.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives.NonEmptyString(impl.name())
    override val slots: Option[
      Map[NonEmptyString, zio.aws.lexruntimev2.model.Slot.ReadOnly]
    ] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.lexruntimev2.model.Slot.wrap(value)
          })
          .toMap
      )
    override val state: Option[zio.aws.lexruntimev2.model.IntentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.lexruntimev2.model.IntentState.wrap(value))
    override val confirmationState
        : Option[zio.aws.lexruntimev2.model.ConfirmationState] = scala
      .Option(impl.confirmationState())
      .map(value => zio.aws.lexruntimev2.model.ConfirmationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Intent
  ): zio.aws.lexruntimev2.model.Intent.ReadOnly = new Wrapper(impl)
}
