package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters.*
sealed trait ConversationMode {
  def unwrap
      : software.amazon.awssdk.services.lexruntimev2.model.ConversationMode
}
object ConversationMode {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.ConversationMode
  ): zio.aws.lexruntimev2.model.ConversationMode = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.AUDIO =>
      val r = AUDIO
      r
    case software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.TEXT =>
      val r = TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.ConversationMode {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConversationMode =
      software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUDIO extends zio.aws.lexruntimev2.model.ConversationMode {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConversationMode =
      software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.AUDIO
  }
  case object TEXT extends zio.aws.lexruntimev2.model.ConversationMode {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.ConversationMode =
      software.amazon.awssdk.services.lexruntimev2.model.ConversationMode.TEXT
  }
}
