package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters._
sealed trait PlaybackInterruptionReason {
  def unwrap: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason
}
object PlaybackInterruptionReason {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason
  ): zio.aws.lexruntimev2.model.PlaybackInterruptionReason = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.DTMF_START_DETECTED =>
      val r = DTMF_START_DETECTED
      r
    case software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.TEXT_DETECTED =>
      val r = TEXT_DETECTED
      r
    case software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.VOICE_START_DETECTED =>
      val r = VOICE_START_DETECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.PlaybackInterruptionReason {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason =
      software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.UNKNOWN_TO_SDK_VERSION
  }
  case object DTMF_START_DETECTED
      extends zio.aws.lexruntimev2.model.PlaybackInterruptionReason {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason =
      software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.DTMF_START_DETECTED
  }
  case object TEXT_DETECTED
      extends zio.aws.lexruntimev2.model.PlaybackInterruptionReason {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason =
      software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.TEXT_DETECTED
  }
  case object VOICE_START_DETECTED
      extends zio.aws.lexruntimev2.model.PlaybackInterruptionReason {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason =
      software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionReason.VOICE_START_DETECTED
  }
}
