package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  LocaleId,
  BotAliasIdentifier,
  BotIdentifier,
  SessionId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutSessionRequest(
    botId: BotIdentifier,
    botAliasId: BotAliasIdentifier,
    localeId: LocaleId,
    sessionId: SessionId,
    messages: Optional[Iterable[zio.aws.lexruntimev2.model.Message]] =
      Optional.Absent,
    sessionState: zio.aws.lexruntimev2.model.SessionState,
    requestAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    responseContentType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest = {
    import PutSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasIdentifier.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .sessionState(sessionState.buildAwsValue())
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .optionallyWith(
        responseContentType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.responseContentType)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.PutSessionRequest.ReadOnly =
    zio.aws.lexruntimev2.model.PutSessionRequest.wrap(buildAwsValue())
}
object PutSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.PutSessionRequest =
      zio.aws.lexruntimev2.model.PutSessionRequest(
        botId,
        botAliasId,
        localeId,
        sessionId,
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionState.asEditable,
        requestAttributes.map(value => value),
        responseContentType.map(value => value)
      )
    def botId: BotIdentifier
    def botAliasId: BotAliasIdentifier
    def localeId: LocaleId
    def sessionId: SessionId
    def messages: Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def sessionState: zio.aws.lexruntimev2.model.SessionState.ReadOnly
    def requestAttributes: Optional[Map[NonEmptyString, String]]
    def responseContentType: Optional[NonEmptyString]
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasIdentifier] =
      ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getSessionState
        : ZIO[Any, Nothing, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      ZIO.succeed(sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getResponseContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("responseContentType", responseContentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest
  ) extends zio.aws.lexruntimev2.model.PutSessionRequest.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botAliasId: BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives
        .BotAliasIdentifier(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexruntimev2.model.primitives.LocaleId(impl.localeId())
    override val sessionId: SessionId =
      zio.aws.lexruntimev2.model.primitives.SessionId(impl.sessionId())
    override val messages
        : Optional[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Message.wrap(item)
          }.toList
        )
    override val sessionState
        : zio.aws.lexruntimev2.model.SessionState.ReadOnly =
      zio.aws.lexruntimev2.model.SessionState.wrap(impl.sessionState())
    override val requestAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexruntimev2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val responseContentType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseContentType())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest
  ): zio.aws.lexruntimev2.model.PutSessionRequest.ReadOnly = new Wrapper(impl)
}
