package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfidenceScore(score: Optional[Double] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore = {
    import ConfidenceScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Double))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly =
    zio.aws.lexruntimev2.model.ConfidenceScore.wrap(buildAwsValue())
}
object ConfidenceScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.ConfidenceScore =
      zio.aws.lexruntimev2.model.ConfidenceScore(score.map(value => value))
    def score: Optional[Double]
    def getScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore
  ) extends zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly {
    override val score: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfidenceScore
  ): zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly = new Wrapper(impl)
}
