package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  SessionId,
  LocaleId,
  BotAliasIdentifier,
  BotIdentifier
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetSessionRequest(
    botId: BotIdentifier,
    botAliasId: BotAliasIdentifier,
    localeId: LocaleId,
    sessionId: SessionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest = {
    import GetSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasIdentifier.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.GetSessionRequest.ReadOnly =
    zio.aws.lexruntimev2.model.GetSessionRequest.wrap(buildAwsValue())
}
object GetSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.GetSessionRequest =
      zio.aws.lexruntimev2.model.GetSessionRequest(
        botId,
        botAliasId,
        localeId,
        sessionId
      )
    def botId: BotIdentifier
    def botAliasId: BotAliasIdentifier
    def localeId: LocaleId
    def sessionId: SessionId
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasIdentifier] =
      ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest
  ) extends zio.aws.lexruntimev2.model.GetSessionRequest.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botAliasId: BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives
        .BotAliasIdentifier(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexruntimev2.model.primitives.LocaleId(impl.localeId())
    override val sessionId: SessionId =
      zio.aws.lexruntimev2.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest
  ): zio.aws.lexruntimev2.model.GetSessionRequest.ReadOnly = new Wrapper(impl)
}
