package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{Name, BotIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecognizedBotMember(
    botId: BotIdentifier,
    botName: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizedBotMember = {
    import RecognizedBotMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizedBotMember
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .optionallyWith(
        botName.map(value => Name.unwrap(value): java.lang.String)
      )(_.botName)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RecognizedBotMember.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizedBotMember.wrap(buildAwsValue())
}
object RecognizedBotMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizedBotMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizedBotMember =
      zio.aws.lexruntimev2.model
        .RecognizedBotMember(botId, botName.map(value => value))
    def botId: BotIdentifier
    def botName: Optional[Name]
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("botName", botName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizedBotMember
  ) extends zio.aws.lexruntimev2.model.RecognizedBotMember.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.botName())
      .map(value => zio.aws.lexruntimev2.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizedBotMember
  ): zio.aws.lexruntimev2.model.RecognizedBotMember.ReadOnly = new Wrapper(impl)
}
