package zio.aws.lexruntimev2
import zio.aws.lexruntimev2.model.primitives.{
  NonEmptyString,
  Name,
  Text,
  ParameterName
}
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.lexruntimev2.model.primitives.AttachmentUrl.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ActiveContextName extends Subtype[String]
    type ActiveContextName =
      zio.aws.lexruntimev2.model.primitives.ActiveContextName.Type
    object ActiveContextTimeToLiveInSeconds extends Subtype[Int]
    type ActiveContextTimeToLiveInSeconds =
      zio.aws.lexruntimev2.model.primitives.ActiveContextTimeToLiveInSeconds.Type
    object ActiveContextTurnsToLive extends Subtype[Int]
    type ActiveContextTurnsToLive =
      zio.aws.lexruntimev2.model.primitives.ActiveContextTurnsToLive.Type
    object AttachmentTitle extends Subtype[String]
    type AttachmentTitle =
      zio.aws.lexruntimev2.model.primitives.AttachmentTitle.Type
    object AttachmentUrl extends Subtype[String]
    type AttachmentUrl =
      zio.aws.lexruntimev2.model.primitives.AttachmentUrl.Type
    object AudioChunk extends Subtype[Chunk[Byte]]
    type AudioChunk = zio.aws.lexruntimev2.model.primitives.AudioChunk.Type
    object BlobStream extends Subtype[Chunk[Byte]]
    type BlobStream = zio.aws.lexruntimev2.model.primitives.BlobStream.Type
    object BotAliasIdentifier extends Subtype[String]
    type BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotAliasIdentifier.Type
    object BotIdentifier extends Subtype[String]
    type BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier.Type
    object ButtonText extends Subtype[String]
    type ButtonText = zio.aws.lexruntimev2.model.primitives.ButtonText.Type
    object ButtonValue extends Subtype[String]
    type ButtonValue = zio.aws.lexruntimev2.model.primitives.ButtonValue.Type
    object DTMFRegex extends Subtype[String]
    type DTMFRegex = zio.aws.lexruntimev2.model.primitives.DTMFRegex.Type
    object EpochMillis extends Subtype[Long]
    type EpochMillis = zio.aws.lexruntimev2.model.primitives.EpochMillis.Type
    object EventId extends Subtype[String]
    type EventId = zio.aws.lexruntimev2.model.primitives.EventId.Type
    object LocaleId extends Subtype[String]
    type LocaleId = zio.aws.lexruntimev2.model.primitives.LocaleId.Type
    object Name extends Subtype[String]
    type Name = zio.aws.lexruntimev2.model.primitives.Name.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.lexruntimev2.model.primitives.NonEmptyString.Type
    object ParameterName extends Subtype[String]
    type ParameterName =
      zio.aws.lexruntimev2.model.primitives.ParameterName.Type
    object RuntimeHintPhrase extends Subtype[String]
    type RuntimeHintPhrase =
      zio.aws.lexruntimev2.model.primitives.RuntimeHintPhrase.Type
    object SensitiveNonEmptyString extends Subtype[String]
    type SensitiveNonEmptyString =
      zio.aws.lexruntimev2.model.primitives.SensitiveNonEmptyString.Type
    object SessionId extends Subtype[String]
    type SessionId = zio.aws.lexruntimev2.model.primitives.SessionId.Type
    object Text extends Subtype[String]
    type Text = zio.aws.lexruntimev2.model.primitives.Text.Type
  }
  type ActiveContextParametersMap = Map[ParameterName, Text]
  type ActiveContextsList = List[zio.aws.lexruntimev2.model.ActiveContext]
  type ButtonsList = List[zio.aws.lexruntimev2.model.Button]
  type Interpretations = List[zio.aws.lexruntimev2.model.Interpretation]
  type Messages = List[zio.aws.lexruntimev2.model.Message]
  type RuntimeHintValuesList = List[zio.aws.lexruntimev2.model.RuntimeHintValue]
  type SlotHintsIntentMap =
    Map[Name, Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails]]
  type SlotHintsSlotMap =
    Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails]
  type Slots = Map[NonEmptyString, zio.aws.lexruntimev2.model.Slot]
  type StringList = List[NonEmptyString]
  type StringMap = Map[NonEmptyString, String]
  type Values = List[zio.aws.lexruntimev2.model.Slot]
}
