package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Value(
    originalValue: Optional[NonEmptyString] = Optional.Absent,
    interpretedValue: NonEmptyString,
    resolvedValues: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.Value = {
    import Value.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.Value
      .builder()
      .optionallyWith(
        originalValue.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originalValue)
      .interpretedValue(
        NonEmptyString.unwrap(interpretedValue): java.lang.String
      )
      .optionallyWith(
        resolvedValues.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resolvedValues)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.Value.ReadOnly =
    zio.aws.lexruntimev2.model.Value.wrap(buildAwsValue())
}
object Value {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.Value
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.Value =
      zio.aws.lexruntimev2.model.Value(
        originalValue.map(value => value),
        interpretedValue,
        resolvedValues.map(value => value)
      )
    def originalValue: Optional[NonEmptyString]
    def interpretedValue: NonEmptyString
    def resolvedValues: Optional[List[NonEmptyString]]
    def getOriginalValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originalValue", originalValue)
    def getInterpretedValue: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(interpretedValue)
    def getResolvedValues: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("resolvedValues", resolvedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Value
  ) extends zio.aws.lexruntimev2.model.Value.ReadOnly {
    override val originalValue: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.originalValue())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val interpretedValue: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives
        .NonEmptyString(impl.interpretedValue())
    override val resolvedValues: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Value
  ): zio.aws.lexruntimev2.model.Value.ReadOnly = new Wrapper(impl)
}
