package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RuntimeHints(
    slotHints: Optional[
      Map[Name, Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RuntimeHints = {
    import RuntimeHints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RuntimeHints
      .builder()
      .optionallyWith(
        slotHints.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
                })
                .asJava
            })
            .asJava
        )
      )(_.slotHints)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly =
    zio.aws.lexruntimev2.model.RuntimeHints.wrap(buildAwsValue())
}
object RuntimeHints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RuntimeHints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RuntimeHints =
      zio.aws.lexruntimev2.model.RuntimeHints(
        slotHints.map(value =>
          value.map({ case (key, value) =>
            key -> value.map({ case (key, value) =>
              key -> value.asEditable
            })
          })
        )
      )
    def slotHints: Optional[Map[
      Name,
      Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly]
    ]]
    def getSlotHints: ZIO[Any, AwsError, Map[
      Name,
      Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly]
    ]] = AwsError.unwrapOptionField("slotHints", slotHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RuntimeHints
  ) extends zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly {
    override val slotHints: Optional[Map[
      Name,
      Map[Name, zio.aws.lexruntimev2.model.RuntimeHintDetails.ReadOnly]
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.slotHints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives.Name(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.lexruntimev2.model.primitives.Name(
                  key
                ) -> zio.aws.lexruntimev2.model.RuntimeHintDetails.wrap(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RuntimeHints
  ): zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly = new Wrapper(impl)
}
