package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Interpretation(
    nluConfidence: Optional[zio.aws.lexruntimev2.model.ConfidenceScore] =
      Optional.Absent,
    sentimentResponse: Optional[zio.aws.lexruntimev2.model.SentimentResponse] =
      Optional.Absent,
    intent: Optional[zio.aws.lexruntimev2.model.Intent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.Interpretation = {
    import Interpretation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.Interpretation
      .builder()
      .optionallyWith(nluConfidence.map(value => value.buildAwsValue()))(
        _.nluConfidence
      )
      .optionallyWith(sentimentResponse.map(value => value.buildAwsValue()))(
        _.sentimentResponse
      )
      .optionallyWith(intent.map(value => value.buildAwsValue()))(_.intent)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.Interpretation.ReadOnly =
    zio.aws.lexruntimev2.model.Interpretation.wrap(buildAwsValue())
}
object Interpretation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.Interpretation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.Interpretation =
      zio.aws.lexruntimev2.model.Interpretation(
        nluConfidence.map(value => value.asEditable),
        sentimentResponse.map(value => value.asEditable),
        intent.map(value => value.asEditable)
      )
    def nluConfidence
        : Optional[zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly]
    def sentimentResponse
        : Optional[zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly]
    def intent: Optional[zio.aws.lexruntimev2.model.Intent.ReadOnly]
    def getNluConfidence: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly
    ] = AwsError.unwrapOptionField("nluConfidence", nluConfidence)
    def getSentimentResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentResponse", sentimentResponse)
    def getIntent
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      AwsError.unwrapOptionField("intent", intent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Interpretation
  ) extends zio.aws.lexruntimev2.model.Interpretation.ReadOnly {
    override val nluConfidence
        : Optional[zio.aws.lexruntimev2.model.ConfidenceScore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nluConfidence())
        .map(value => zio.aws.lexruntimev2.model.ConfidenceScore.wrap(value))
    override val sentimentResponse
        : Optional[zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentimentResponse())
        .map(value => zio.aws.lexruntimev2.model.SentimentResponse.wrap(value))
    override val intent: Optional[zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intent())
        .map(value => zio.aws.lexruntimev2.model.Intent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Interpretation
  ): zio.aws.lexruntimev2.model.Interpretation.ReadOnly = new Wrapper(impl)
}
