package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ElicitSubSlot(
    name: NonEmptyString,
    subSlotToElicit: Optional[zio.aws.lexruntimev2.model.ElicitSubSlot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot = {
    import ElicitSubSlot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot
      .builder()
      .name(NonEmptyString.unwrap(name): java.lang.String)
      .optionallyWith(subSlotToElicit.map(value => value.buildAwsValue()))(
        _.subSlotToElicit
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly =
    zio.aws.lexruntimev2.model.ElicitSubSlot.wrap(buildAwsValue())
}
object ElicitSubSlot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.ElicitSubSlot =
      zio.aws.lexruntimev2.model
        .ElicitSubSlot(name, subSlotToElicit.map(value => value.asEditable))
    def name: NonEmptyString
    def subSlotToElicit
        : Optional[zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly]
    def getName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(name)
    def getSubSlotToElicit: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly
    ] = AwsError.unwrapOptionField("subSlotToElicit", subSlotToElicit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot
  ) extends zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly {
    override val name: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives.NonEmptyString(impl.name())
    override val subSlotToElicit
        : Optional[zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subSlotToElicit())
        .map(value => zio.aws.lexruntimev2.model.ElicitSubSlot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot
  ): zio.aws.lexruntimev2.model.ElicitSubSlot.ReadOnly = new Wrapper(impl)
}
