package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  EpochMillis,
  EventId,
  NonEmptyString,
  AudioChunk
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AudioInputEvent(
    audioChunk: Optional[AudioChunk] = Optional.Absent,
    contentType: NonEmptyString,
    eventId: Optional[EventId] = Optional.Absent,
    clientTimestampMillis: Optional[EpochMillis] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent = {
    import AudioInputEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent
      .builder()
      .optionallyWith(
        audioChunk.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.audioChunk)
      .contentType(NonEmptyString.unwrap(contentType): java.lang.String)
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.AudioInputEvent.ReadOnly =
    zio.aws.lexruntimev2.model.AudioInputEvent.wrap(buildAwsValue())
}
object AudioInputEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.AudioInputEvent =
      zio.aws.lexruntimev2.model.AudioInputEvent(
        audioChunk.map(value => value),
        contentType,
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def audioChunk: Optional[AudioChunk]
    def contentType: NonEmptyString
    def eventId: Optional[EventId]
    def clientTimestampMillis: Optional[EpochMillis]
    def getAudioChunk: ZIO[Any, AwsError, AudioChunk] =
      AwsError.unwrapOptionField("audioChunk", audioChunk)
    def getContentType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(contentType)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent
  ) extends zio.aws.lexruntimev2.model.AudioInputEvent.ReadOnly {
    override val audioChunk: Optional[AudioChunk] = zio.aws.core.internal
      .optionalFromNullable(impl.audioChunk())
      .map(value =>
        zio.aws.lexruntimev2.model.primitives
          .AudioChunk(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val contentType: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives.NonEmptyString(impl.contentType())
    override val eventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Optional[EpochMillis] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientTimestampMillis())
        .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.AudioInputEvent
  ): zio.aws.lexruntimev2.model.AudioInputEvent.ReadOnly = new Wrapper(impl)
}
