package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SessionState(
    dialogAction: Optional[zio.aws.lexruntimev2.model.DialogAction] =
      Optional.Absent,
    intent: Optional[zio.aws.lexruntimev2.model.Intent] = Optional.Absent,
    activeContexts: Optional[
      Iterable[zio.aws.lexruntimev2.model.ActiveContext]
    ] = Optional.Absent,
    sessionAttributes: Optional[Map[NonEmptyString, String]] = Optional.Absent,
    originatingRequestId: Optional[NonEmptyString] = Optional.Absent,
    runtimeHints: Optional[zio.aws.lexruntimev2.model.RuntimeHints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.SessionState = {
    import SessionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.SessionState
      .builder()
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(intent.map(value => value.buildAwsValue()))(_.intent)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        originatingRequestId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originatingRequestId)
      .optionallyWith(runtimeHints.map(value => value.buildAwsValue()))(
        _.runtimeHints
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.SessionState.ReadOnly =
    zio.aws.lexruntimev2.model.SessionState.wrap(buildAwsValue())
}
object SessionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.SessionState =
      zio.aws.lexruntimev2.model.SessionState(
        dialogAction.map(value => value.asEditable),
        intent.map(value => value.asEditable),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionAttributes.map(value => value),
        originatingRequestId.map(value => value),
        runtimeHints.map(value => value.asEditable)
      )
    def dialogAction: Optional[zio.aws.lexruntimev2.model.DialogAction.ReadOnly]
    def intent: Optional[zio.aws.lexruntimev2.model.Intent.ReadOnly]
    def activeContexts
        : Optional[List[zio.aws.lexruntimev2.model.ActiveContext.ReadOnly]]
    def sessionAttributes: Optional[Map[NonEmptyString, String]]
    def originatingRequestId: Optional[NonEmptyString]
    def runtimeHints: Optional[zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly]
    def getDialogAction
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.DialogAction.ReadOnly] =
      AwsError.unwrapOptionField("dialogAction", dialogAction)
    def getIntent
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      AwsError.unwrapOptionField("intent", intent)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
    def getSessionAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getOriginatingRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originatingRequestId", originatingRequestId)
    def getRuntimeHints
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly] =
      AwsError.unwrapOptionField("runtimeHints", runtimeHints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ) extends zio.aws.lexruntimev2.model.SessionState.ReadOnly {
    override val dialogAction
        : Optional[zio.aws.lexruntimev2.model.DialogAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dialogAction())
        .map(value => zio.aws.lexruntimev2.model.DialogAction.wrap(value))
    override val intent: Optional[zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intent())
        .map(value => zio.aws.lexruntimev2.model.Intent.wrap(value))
    override val activeContexts
        : Optional[List[zio.aws.lexruntimev2.model.ActiveContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.ActiveContext.wrap(item)
          }.toList
        )
    override val sessionAttributes: Optional[Map[NonEmptyString, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.lexruntimev2.model.primitives
                .NonEmptyString(key) -> (value: String)
            })
            .toMap
        )
    override val originatingRequestId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originatingRequestId())
        .map(value =>
          zio.aws.lexruntimev2.model.primitives.NonEmptyString(value)
        )
    override val runtimeHints
        : Optional[zio.aws.lexruntimev2.model.RuntimeHints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeHints())
        .map(value => zio.aws.lexruntimev2.model.RuntimeHints.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ): zio.aws.lexruntimev2.model.SessionState.ReadOnly = new Wrapper(impl)
}
