package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.EventId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlaybackInterruptionEvent(
    eventReason: Optional[
      zio.aws.lexruntimev2.model.PlaybackInterruptionReason
    ] = Optional.Absent,
    causedByEventId: Optional[EventId] = Optional.Absent,
    eventId: Optional[EventId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent = {
    import PlaybackInterruptionEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
      .builder()
      .optionallyWith(eventReason.map(value => value.unwrap))(_.eventReason)
      .optionallyWith(
        causedByEventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.causedByEventId)
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly =
    zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.wrap(buildAwsValue())
}
object PlaybackInterruptionEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.PlaybackInterruptionEvent =
      zio.aws.lexruntimev2.model.PlaybackInterruptionEvent(
        eventReason.map(value => value),
        causedByEventId.map(value => value),
        eventId.map(value => value)
      )
    def eventReason
        : Optional[zio.aws.lexruntimev2.model.PlaybackInterruptionReason]
    def causedByEventId: Optional[EventId]
    def eventId: Optional[EventId]
    def getEventReason: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.PlaybackInterruptionReason
    ] = AwsError.unwrapOptionField("eventReason", eventReason)
    def getCausedByEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("causedByEventId", causedByEventId)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ) extends zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly {
    override val eventReason
        : Optional[zio.aws.lexruntimev2.model.PlaybackInterruptionReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventReason())
        .map(value =>
          zio.aws.lexruntimev2.model.PlaybackInterruptionReason.wrap(value)
        )
    override val causedByEventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.causedByEventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val eventId: Optional[EventId] = zio.aws.core.internal
      .optionalFromNullable(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ): zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly =
    new Wrapper(impl)
}
