package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Slot(
    value: Optional[zio.aws.lexruntimev2.model.Value] = Optional.Absent,
    shape: Optional[zio.aws.lexruntimev2.model.Shape] = Optional.Absent,
    values: Optional[Iterable[zio.aws.lexruntimev2.model.Slot]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.Slot = {
    import Slot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.Slot
      .builder()
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(shape.map(value => value.unwrap))(_.shape)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.Slot.ReadOnly =
    zio.aws.lexruntimev2.model.Slot.wrap(buildAwsValue())
}
object Slot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lexruntimev2.model.Slot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.Slot =
      zio.aws.lexruntimev2.model.Slot(
        value.map(value => value.asEditable),
        shape.map(value => value),
        values.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def value: Optional[zio.aws.lexruntimev2.model.Value.ReadOnly]
    def shape: Optional[zio.aws.lexruntimev2.model.Shape]
    def values: Optional[List[zio.aws.lexruntimev2.model.Slot.ReadOnly]]
    def getValue
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.Value.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getShape: ZIO[Any, AwsError, zio.aws.lexruntimev2.model.Shape] =
      AwsError.unwrapOptionField("shape", shape)
    def getValues
        : ZIO[Any, AwsError, List[zio.aws.lexruntimev2.model.Slot.ReadOnly]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Slot
  ) extends zio.aws.lexruntimev2.model.Slot.ReadOnly {
    override val value: Optional[zio.aws.lexruntimev2.model.Value.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.lexruntimev2.model.Value.wrap(value))
    override val shape: Optional[zio.aws.lexruntimev2.model.Shape] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shape())
        .map(value => zio.aws.lexruntimev2.model.Shape.wrap(value))
    override val values
        : Optional[List[zio.aws.lexruntimev2.model.Slot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Slot.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.Slot
  ): zio.aws.lexruntimev2.model.Slot.ReadOnly = new Wrapper(impl)
}
