package zio.aws.lexruntimev2
import zio.aws.lexruntimev2.model.RecognizeTextResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2AsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.lexruntimev2.model.{
  RecognizeUtteranceRequest,
  ConfigurationEvent,
  RecognizeTextRequest,
  DeleteSessionRequest,
  GetSessionRequest,
  StartConversationRequest,
  PutSessionRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object LexRuntimeV2Mock extends Mock[LexRuntimeV2] {
  object StartConversation
      extends Stream[
        Tuple2[StartConversationRequest, ZStream[
          Any,
          AwsError,
          ConfigurationEvent
        ]],
        AwsError,
        zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly
      ]
  object RecognizeUtterance
      extends Effect[
        Tuple2[RecognizeUtteranceRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly,
          Byte
        ]
      ]
  object DeleteSession
      extends Effect[
        DeleteSessionRequest,
        AwsError,
        zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly
      ]
  object RecognizeText extends Effect[RecognizeTextRequest, AwsError, ReadOnly]
  object PutSession
      extends Effect[PutSessionRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.lexruntimev2.model.PutSessionResponse.ReadOnly,
        Byte
      ]]
  object GetSession
      extends Effect[
        GetSessionRequest,
        AwsError,
        zio.aws.lexruntimev2.model.GetSessionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LexRuntimeV2] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new LexRuntimeV2 {
          val api: LexRuntimeV2AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : LexRuntimeV2 = this
          def startConversation(
              request: StartConversationRequest,
              input: ZStream[Any, AwsError, ConfigurationEvent]
          ): ZStream[
            Any,
            AwsError,
            zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly
          ] = rts.unsafeRun(proxy(StartConversation, request, input))
          def recognizeUtterance(
              request: RecognizeUtteranceRequest,
              body: ZStream[Any, AwsError, Byte]
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.lexruntimev2.model.RecognizeUtteranceResponse.ReadOnly,
            Byte
          ]] = proxy(RecognizeUtterance, request, body)
          def deleteSession(request: DeleteSessionRequest): IO[
            AwsError,
            zio.aws.lexruntimev2.model.DeleteSessionResponse.ReadOnly
          ] = proxy(DeleteSession, request)
          def recognizeText(
              request: RecognizeTextRequest
          ): IO[AwsError, ReadOnly] = proxy(RecognizeText, request)
          def putSession(
              request: PutSessionRequest
          ): IO[AwsError, StreamingOutputResult[
            Any,
            zio.aws.lexruntimev2.model.PutSessionResponse.ReadOnly,
            Byte
          ]] = proxy(PutSession, request)
          def getSession(request: GetSessionRequest): IO[
            AwsError,
            zio.aws.lexruntimev2.model.GetSessionResponse.ReadOnly
          ] = proxy(GetSession, request)
        }
      }
    }
    .toLayer
}
