package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{EpochMillis, EventId, Text}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TextInputEvent(
    text: Text,
    eventId: Option[EventId] = None,
    clientTimestampMillis: Option[EpochMillis] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent = {
    import TextInputEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent
      .builder()
      .text(Text.unwrap(text): java.lang.String)
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.TextInputEvent.ReadOnly =
    zio.aws.lexruntimev2.model.TextInputEvent.wrap(buildAwsValue())
}
object TextInputEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.TextInputEvent =
      zio.aws.lexruntimev2.model.TextInputEvent(
        text,
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def text: Text
    def eventId: Option[EventId]
    def clientTimestampMillis: Option[EpochMillis]
    def getText: ZIO[Any, Nothing, Text] = ZIO.succeed(text)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent
  ) extends zio.aws.lexruntimev2.model.TextInputEvent.ReadOnly {
    override val text: Text =
      zio.aws.lexruntimev2.model.primitives.Text(impl.text())
    override val eventId: Option[EventId] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Option[EpochMillis] = scala
      .Option(impl.clientTimestampMillis())
      .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.TextInputEvent
  ): zio.aws.lexruntimev2.model.TextInputEvent.ReadOnly = new Wrapper(impl)
}
