package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{SessionId, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutSessionResponse(
    contentType: Option[NonEmptyString] = None,
    messages: Option[NonEmptyString] = None,
    sessionState: Option[NonEmptyString] = None,
    requestAttributes: Option[NonEmptyString] = None,
    sessionId: Option[SessionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse = {
    import PutSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse
      .builder()
      .optionallyWith(
        contentType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(
        messages.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.messages)
      .optionallyWith(
        sessionState.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionState)
      .optionallyWith(
        requestAttributes.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.requestAttributes)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.PutSessionResponse.ReadOnly =
    zio.aws.lexruntimev2.model.PutSessionResponse.wrap(buildAwsValue())
}
object PutSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.PutSessionResponse =
      zio.aws.lexruntimev2.model.PutSessionResponse(
        contentType.map(value => value),
        messages.map(value => value),
        sessionState.map(value => value),
        requestAttributes.map(value => value),
        sessionId.map(value => value)
      )
    def contentType: Option[NonEmptyString]
    def messages: Option[NonEmptyString]
    def sessionState: Option[NonEmptyString]
    def requestAttributes: Option[NonEmptyString]
    def sessionId: Option[SessionId]
    def getContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getMessages: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("messages", messages)
    def getSessionState: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse
  ) extends zio.aws.lexruntimev2.model.PutSessionResponse.ReadOnly {
    override val contentType: Option[NonEmptyString] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val messages: Option[NonEmptyString] = scala
      .Option(impl.messages())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val sessionState: Option[NonEmptyString] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val requestAttributes: Option[NonEmptyString] = scala
      .Option(impl.requestAttributes())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val sessionId: Option[SessionId] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse
  ): zio.aws.lexruntimev2.model.PutSessionResponse.ReadOnly = new Wrapper(impl)
}
