package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  LocaleId,
  SensitiveNonEmptyString,
  BotAliasIdentifier,
  BotIdentifier,
  SessionId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecognizeUtteranceRequest(
    botId: BotIdentifier,
    botAliasId: BotAliasIdentifier,
    localeId: LocaleId,
    sessionId: SessionId,
    sessionState: Option[SensitiveNonEmptyString] = None,
    requestAttributes: Option[SensitiveNonEmptyString] = None,
    requestContentType: NonEmptyString,
    responseContentType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest = {
    import RecognizeUtteranceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest
      .builder()
      .botId(BotIdentifier.unwrap(botId): java.lang.String)
      .botAliasId(BotAliasIdentifier.unwrap(botAliasId): java.lang.String)
      .localeId(LocaleId.unwrap(localeId): java.lang.String)
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .optionallyWith(
        sessionState.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sessionState)
      .optionallyWith(
        requestAttributes.map(value =>
          SensitiveNonEmptyString.unwrap(value): java.lang.String
        )
      )(_.requestAttributes)
      .requestContentType(
        NonEmptyString.unwrap(requestContentType): java.lang.String
      )
      .optionallyWith(
        responseContentType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.responseContentType)
      .build()
  }
  def asReadOnly
      : zio.aws.lexruntimev2.model.RecognizeUtteranceRequest.ReadOnly =
    zio.aws.lexruntimev2.model.RecognizeUtteranceRequest.wrap(buildAwsValue())
}
object RecognizeUtteranceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.RecognizeUtteranceRequest =
      zio.aws.lexruntimev2.model.RecognizeUtteranceRequest(
        botId,
        botAliasId,
        localeId,
        sessionId,
        sessionState.map(value => value),
        requestAttributes.map(value => value),
        requestContentType,
        responseContentType.map(value => value)
      )
    def botId: BotIdentifier
    def botAliasId: BotAliasIdentifier
    def localeId: LocaleId
    def sessionId: SessionId
    def sessionState: Option[SensitiveNonEmptyString]
    def requestAttributes: Option[SensitiveNonEmptyString]
    def requestContentType: NonEmptyString
    def responseContentType: Option[NonEmptyString]
    def getBotId: ZIO[Any, Nothing, BotIdentifier] = ZIO.succeed(botId)
    def getBotAliasId: ZIO[Any, Nothing, BotAliasIdentifier] =
      ZIO.succeed(botAliasId)
    def getLocaleId: ZIO[Any, Nothing, LocaleId] = ZIO.succeed(localeId)
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
    def getSessionState: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getRequestAttributes: ZIO[Any, AwsError, SensitiveNonEmptyString] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getRequestContentType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(requestContentType)
    def getResponseContentType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("responseContentType", responseContentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest
  ) extends zio.aws.lexruntimev2.model.RecognizeUtteranceRequest.ReadOnly {
    override val botId: BotIdentifier =
      zio.aws.lexruntimev2.model.primitives.BotIdentifier(impl.botId())
    override val botAliasId: BotAliasIdentifier =
      zio.aws.lexruntimev2.model.primitives
        .BotAliasIdentifier(impl.botAliasId())
    override val localeId: LocaleId =
      zio.aws.lexruntimev2.model.primitives.LocaleId(impl.localeId())
    override val sessionId: SessionId =
      zio.aws.lexruntimev2.model.primitives.SessionId(impl.sessionId())
    override val sessionState: Option[SensitiveNonEmptyString] = scala
      .Option(impl.sessionState())
      .map(value =>
        zio.aws.lexruntimev2.model.primitives.SensitiveNonEmptyString(value)
      )
    override val requestAttributes: Option[SensitiveNonEmptyString] = scala
      .Option(impl.requestAttributes())
      .map(value =>
        zio.aws.lexruntimev2.model.primitives.SensitiveNonEmptyString(value)
      )
    override val requestContentType: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives
        .NonEmptyString(impl.requestContentType())
    override val responseContentType: Option[NonEmptyString] = scala
      .Option(impl.responseContentType())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest
  ): zio.aws.lexruntimev2.model.RecognizeUtteranceRequest.ReadOnly =
    new Wrapper(impl)
}
