package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSessionResponse(
    sessionId: Option[NonEmptyString] = None,
    messages: Option[Iterable[zio.aws.lexruntimev2.model.Message]] = None,
    interpretations: Option[
      Iterable[zio.aws.lexruntimev2.model.Interpretation]
    ] = None,
    sessionState: Option[zio.aws.lexruntimev2.model.SessionState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse = {
    import GetSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(
        interpretations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.interpretations)
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.GetSessionResponse.ReadOnly =
    zio.aws.lexruntimev2.model.GetSessionResponse.wrap(buildAwsValue())
}
object GetSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.GetSessionResponse =
      zio.aws.lexruntimev2.model.GetSessionResponse(
        sessionId.map(value => value),
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        interpretations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionState.map(value => value.asEditable)
      )
    def sessionId: Option[NonEmptyString]
    def messages: Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def interpretations
        : Option[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]]
    def sessionState: Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def getSessionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getInterpretations: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Interpretation.ReadOnly
    ]] = AwsError.unwrapOptionField("interpretations", interpretations)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse
  ) extends zio.aws.lexruntimev2.model.GetSessionResponse.ReadOnly {
    override val sessionId: Option[NonEmptyString] = scala
      .Option(impl.sessionId())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val messages
        : Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] = scala
      .Option(impl.messages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntimev2.model.Message.wrap(item)
        }.toList
      )
    override val interpretations
        : Option[List[zio.aws.lexruntimev2.model.Interpretation.ReadOnly]] =
      scala
        .Option(impl.interpretations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.Interpretation.wrap(item)
          }.toList
        )
    override val sessionState
        : Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse
  ): zio.aws.lexruntimev2.model.GetSessionResponse.ReadOnly = new Wrapper(impl)
}
