package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{EpochMillis, EventId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisconnectionEvent(
    eventId: Option[EventId] = None,
    clientTimestampMillis: Option[EpochMillis] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent = {
    import DisconnectionEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent
      .builder()
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.DisconnectionEvent.ReadOnly =
    zio.aws.lexruntimev2.model.DisconnectionEvent.wrap(buildAwsValue())
}
object DisconnectionEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.DisconnectionEvent =
      zio.aws.lexruntimev2.model.DisconnectionEvent(
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def eventId: Option[EventId]
    def clientTimestampMillis: Option[EpochMillis]
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent
  ) extends zio.aws.lexruntimev2.model.DisconnectionEvent.ReadOnly {
    override val eventId: Option[EventId] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Option[EpochMillis] = scala
      .Option(impl.clientTimestampMillis())
      .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DisconnectionEvent
  ): zio.aws.lexruntimev2.model.DisconnectionEvent.ReadOnly = new Wrapper(impl)
}
