package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DialogAction(
    `type`: zio.aws.lexruntimev2.model.DialogActionType,
    slotToElicit: Option[NonEmptyString] = None,
    slotElicitationStyle: Option[zio.aws.lexruntimev2.model.StyleType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.DialogAction = {
    import DialogAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.DialogAction
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        slotToElicit.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.slotToElicit)
      .optionallyWith(slotElicitationStyle.map(value => value.unwrap))(
        _.slotElicitationStyle
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.DialogAction.ReadOnly =
    zio.aws.lexruntimev2.model.DialogAction.wrap(buildAwsValue())
}
object DialogAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.DialogAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.DialogAction =
      zio.aws.lexruntimev2.model.DialogAction(
        `type`,
        slotToElicit.map(value => value),
        slotElicitationStyle.map(value => value)
      )
    def `type`: zio.aws.lexruntimev2.model.DialogActionType
    def slotToElicit: Option[NonEmptyString]
    def slotElicitationStyle: Option[zio.aws.lexruntimev2.model.StyleType]
    def getType
        : ZIO[Any, Nothing, zio.aws.lexruntimev2.model.DialogActionType] =
      ZIO.succeed(`type`)
    def getSlotToElicit: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getSlotElicitationStyle
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.StyleType] =
      AwsError.unwrapOptionField("slotElicitationStyle", slotElicitationStyle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DialogAction
  ) extends zio.aws.lexruntimev2.model.DialogAction.ReadOnly {
    override val `type`: zio.aws.lexruntimev2.model.DialogActionType =
      zio.aws.lexruntimev2.model.DialogActionType.wrap(impl.`type`())
    override val slotToElicit: Option[NonEmptyString] = scala
      .Option(impl.slotToElicit())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
    override val slotElicitationStyle
        : Option[zio.aws.lexruntimev2.model.StyleType] = scala
      .Option(impl.slotElicitationStyle())
      .map(value => zio.aws.lexruntimev2.model.StyleType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DialogAction
  ): zio.aws.lexruntimev2.model.DialogAction.ReadOnly = new Wrapper(impl)
}
