package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SentimentResponse(
    sentiment: Option[zio.aws.lexruntimev2.model.SentimentType] = None,
    sentimentScore: Option[zio.aws.lexruntimev2.model.SentimentScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse = {
    import SentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse
      .builder()
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(sentimentScore.map(value => value.buildAwsValue()))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly =
    zio.aws.lexruntimev2.model.SentimentResponse.wrap(buildAwsValue())
}
object SentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.SentimentResponse =
      zio.aws.lexruntimev2.model.SentimentResponse(
        sentiment.map(value => value),
        sentimentScore.map(value => value.asEditable)
      )
    def sentiment: Option[zio.aws.lexruntimev2.model.SentimentType]
    def sentimentScore
        : Option[zio.aws.lexruntimev2.model.SentimentScore.ReadOnly]
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SentimentType] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getSentimentScore: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.SentimentScore.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse
  ) extends zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly {
    override val sentiment: Option[zio.aws.lexruntimev2.model.SentimentType] =
      scala
        .Option(impl.sentiment())
        .map(value => zio.aws.lexruntimev2.model.SentimentType.wrap(value))
    override val sentimentScore
        : Option[zio.aws.lexruntimev2.model.SentimentScore.ReadOnly] = scala
      .Option(impl.sentimentScore())
      .map(value => zio.aws.lexruntimev2.model.SentimentScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SentimentResponse
  ): zio.aws.lexruntimev2.model.SentimentResponse.ReadOnly = new Wrapper(impl)
}
