package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters._
sealed trait StyleType {
  def unwrap: software.amazon.awssdk.services.lexruntimev2.model.StyleType
}
object StyleType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.StyleType
  ): zio.aws.lexruntimev2.model.StyleType = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.StyleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.StyleType.DEFAULT =>
      val r = Default
      r
    case software.amazon.awssdk.services.lexruntimev2.model.StyleType.SPELL_BY_LETTER =>
      val r = SpellByLetter
      r
    case software.amazon.awssdk.services.lexruntimev2.model.StyleType.SPELL_BY_WORD =>
      val r = SpellByWord
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexruntimev2.model.StyleType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.StyleType =
      software.amazon.awssdk.services.lexruntimev2.model.StyleType.UNKNOWN_TO_SDK_VERSION
  }
  case object Default extends zio.aws.lexruntimev2.model.StyleType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.StyleType =
      software.amazon.awssdk.services.lexruntimev2.model.StyleType.DEFAULT
  }
  case object SpellByLetter extends zio.aws.lexruntimev2.model.StyleType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.StyleType =
      software.amazon.awssdk.services.lexruntimev2.model.StyleType.SPELL_BY_LETTER
  }
  case object SpellByWord extends zio.aws.lexruntimev2.model.StyleType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.StyleType =
      software.amazon.awssdk.services.lexruntimev2.model.StyleType.SPELL_BY_WORD
  }
}
