package zio.aws.lexruntimev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SentimentScore(
    positive: Option[Double] = None,
    negative: Option[Double] = None,
    neutral: Option[Double] = None,
    mixed: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.SentimentScore = {
    import SentimentScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.SentimentScore
      .builder()
      .optionallyWith(positive.map(value => value: java.lang.Double))(
        _.positive
      )
      .optionallyWith(negative.map(value => value: java.lang.Double))(
        _.negative
      )
      .optionallyWith(neutral.map(value => value: java.lang.Double))(_.neutral)
      .optionallyWith(mixed.map(value => value: java.lang.Double))(_.mixed)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.SentimentScore.ReadOnly =
    zio.aws.lexruntimev2.model.SentimentScore.wrap(buildAwsValue())
}
object SentimentScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.SentimentScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.SentimentScore =
      zio.aws.lexruntimev2.model.SentimentScore(
        positive.map(value => value),
        negative.map(value => value),
        neutral.map(value => value),
        mixed.map(value => value)
      )
    def positive: Option[Double]
    def negative: Option[Double]
    def neutral: Option[Double]
    def mixed: Option[Double]
    def getPositive: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("positive", positive)
    def getNegative: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("negative", negative)
    def getNeutral: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("neutral", neutral)
    def getMixed: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("mixed", mixed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SentimentScore
  ) extends zio.aws.lexruntimev2.model.SentimentScore.ReadOnly {
    override val positive: Option[Double] =
      scala.Option(impl.positive()).map(value => value: Double)
    override val negative: Option[Double] =
      scala.Option(impl.negative()).map(value => value: Double)
    override val neutral: Option[Double] =
      scala.Option(impl.neutral()).map(value => value: Double)
    override val mixed: Option[Double] =
      scala.Option(impl.mixed()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SentimentScore
  ): zio.aws.lexruntimev2.model.SentimentScore.ReadOnly = new Wrapper(impl)
}
