package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{EpochMillis, EventId, DTMFRegex}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DTMFInputEvent(
    inputCharacter: DTMFRegex,
    eventId: Option[EventId] = None,
    clientTimestampMillis: Option[EpochMillis] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent = {
    import DTMFInputEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent
      .builder()
      .inputCharacter(DTMFRegex.unwrap(inputCharacter): java.lang.String)
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.DTMFInputEvent.ReadOnly =
    zio.aws.lexruntimev2.model.DTMFInputEvent.wrap(buildAwsValue())
}
object DTMFInputEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.DTMFInputEvent =
      zio.aws.lexruntimev2.model.DTMFInputEvent(
        inputCharacter,
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def inputCharacter: DTMFRegex
    def eventId: Option[EventId]
    def clientTimestampMillis: Option[EpochMillis]
    def getInputCharacter: ZIO[Any, Nothing, DTMFRegex] =
      ZIO.succeed(inputCharacter)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent
  ) extends zio.aws.lexruntimev2.model.DTMFInputEvent.ReadOnly {
    override val inputCharacter: DTMFRegex =
      zio.aws.lexruntimev2.model.primitives.DTMFRegex(impl.inputCharacter())
    override val eventId: Option[EventId] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Option[EpochMillis] = scala
      .Option(impl.clientTimestampMillis())
      .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.DTMFInputEvent
  ): zio.aws.lexruntimev2.model.DTMFInputEvent.ReadOnly = new Wrapper(impl)
}
