package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.EventId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PlaybackInterruptionEvent(
    eventReason: Option[zio.aws.lexruntimev2.model.PlaybackInterruptionReason] =
      None,
    causedByEventId: Option[EventId] = None,
    eventId: Option[EventId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent = {
    import PlaybackInterruptionEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
      .builder()
      .optionallyWith(eventReason.map(value => value.unwrap))(_.eventReason)
      .optionallyWith(
        causedByEventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.causedByEventId)
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .build()
  }
  def asReadOnly
      : zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly =
    zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.wrap(buildAwsValue())
}
object PlaybackInterruptionEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.PlaybackInterruptionEvent =
      zio.aws.lexruntimev2.model.PlaybackInterruptionEvent(
        eventReason.map(value => value),
        causedByEventId.map(value => value),
        eventId.map(value => value)
      )
    def eventReason
        : Option[zio.aws.lexruntimev2.model.PlaybackInterruptionReason]
    def causedByEventId: Option[EventId]
    def eventId: Option[EventId]
    def getEventReason: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntimev2.model.PlaybackInterruptionReason
    ] = AwsError.unwrapOptionField("eventReason", eventReason)
    def getCausedByEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("causedByEventId", causedByEventId)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ) extends zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly {
    override val eventReason
        : Option[zio.aws.lexruntimev2.model.PlaybackInterruptionReason] = scala
      .Option(impl.eventReason())
      .map(value =>
        zio.aws.lexruntimev2.model.PlaybackInterruptionReason.wrap(value)
      )
    override val causedByEventId: Option[EventId] = scala
      .Option(impl.causedByEventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val eventId: Option[EventId] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.PlaybackInterruptionEvent
  ): zio.aws.lexruntimev2.model.PlaybackInterruptionEvent.ReadOnly =
    new Wrapper(impl)
}
