package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.{
  EpochMillis,
  EventId,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfigurationEvent(
    requestAttributes: Option[Map[NonEmptyString, String]] = None,
    responseContentType: NonEmptyString,
    sessionState: Option[zio.aws.lexruntimev2.model.SessionState] = None,
    welcomeMessages: Option[Iterable[zio.aws.lexruntimev2.model.Message]] =
      None,
    disablePlayback: Option[Boolean] = None,
    eventId: Option[EventId] = None,
    clientTimestampMillis: Option[EpochMillis] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent = {
    import ConfigurationEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
      .builder()
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(
                key
              ): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .responseContentType(
        NonEmptyString.unwrap(responseContentType): java.lang.String
      )
      .optionallyWith(sessionState.map(value => value.buildAwsValue()))(
        _.sessionState
      )
      .optionallyWith(
        welcomeMessages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.welcomeMessages)
      .optionallyWith(disablePlayback.map(value => value: java.lang.Boolean))(
        _.disablePlayback
      )
      .optionallyWith(
        eventId.map(value => EventId.unwrap(value): java.lang.String)
      )(_.eventId)
      .optionallyWith(
        clientTimestampMillis.map(value =>
          EpochMillis.unwrap(value): java.lang.Long
        )
      )(_.clientTimestampMillis)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly =
    zio.aws.lexruntimev2.model.ConfigurationEvent.wrap(buildAwsValue())
}
object ConfigurationEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.ConfigurationEvent =
      zio.aws.lexruntimev2.model.ConfigurationEvent(
        requestAttributes.map(value => value),
        responseContentType,
        sessionState.map(value => value.asEditable),
        welcomeMessages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disablePlayback.map(value => value),
        eventId.map(value => value),
        clientTimestampMillis.map(value => value)
      )
    def requestAttributes: Option[Map[NonEmptyString, String]]
    def responseContentType: NonEmptyString
    def sessionState: Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly]
    def welcomeMessages
        : Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]]
    def disablePlayback: Option[Boolean]
    def eventId: Option[EventId]
    def clientTimestampMillis: Option[EpochMillis]
    def getRequestAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getResponseContentType: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(responseContentType)
    def getSessionState
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.SessionState.ReadOnly] =
      AwsError.unwrapOptionField("sessionState", sessionState)
    def getWelcomeMessages: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.Message.ReadOnly
    ]] = AwsError.unwrapOptionField("welcomeMessages", welcomeMessages)
    def getDisablePlayback: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disablePlayback", disablePlayback)
    def getEventId: ZIO[Any, AwsError, EventId] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getClientTimestampMillis: ZIO[Any, AwsError, EpochMillis] =
      AwsError.unwrapOptionField("clientTimestampMillis", clientTimestampMillis)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ) extends zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly {
    override val requestAttributes: Option[Map[NonEmptyString, String]] = scala
      .Option(impl.requestAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
    override val responseContentType: NonEmptyString =
      zio.aws.lexruntimev2.model.primitives
        .NonEmptyString(impl.responseContentType())
    override val sessionState
        : Option[zio.aws.lexruntimev2.model.SessionState.ReadOnly] = scala
      .Option(impl.sessionState())
      .map(value => zio.aws.lexruntimev2.model.SessionState.wrap(value))
    override val welcomeMessages
        : Option[List[zio.aws.lexruntimev2.model.Message.ReadOnly]] = scala
      .Option(impl.welcomeMessages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntimev2.model.Message.wrap(item)
        }.toList
      )
    override val disablePlayback: Option[Boolean] =
      scala.Option(impl.disablePlayback()).map(value => value: Boolean)
    override val eventId: Option[EventId] = scala
      .Option(impl.eventId())
      .map(value => zio.aws.lexruntimev2.model.primitives.EventId(value))
    override val clientTimestampMillis: Option[EpochMillis] = scala
      .Option(impl.clientTimestampMillis())
      .map(value => zio.aws.lexruntimev2.model.primitives.EpochMillis(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.ConfigurationEvent
  ): zio.aws.lexruntimev2.model.ConfigurationEvent.ReadOnly = new Wrapper(impl)
}
