package zio.aws.lexruntimev2.model
import scala.jdk.CollectionConverters._
sealed trait MessageContentType {
  def unwrap
      : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType
}
object MessageContentType {
  def wrap(
      value: software.amazon.awssdk.services.lexruntimev2.model.MessageContentType
  ): zio.aws.lexruntimev2.model.MessageContentType = value match {
    case software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.CUSTOM_PAYLOAD =>
      val r = CustomPayload
      r
    case software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.IMAGE_RESPONSE_CARD =>
      val r = ImageResponseCard
      r
    case software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.PLAIN_TEXT =>
      val r = PlainText
      r
    case software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.SSML =>
      val r = SSML
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntimev2.model.MessageContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType =
      software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object CustomPayload
      extends zio.aws.lexruntimev2.model.MessageContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType =
      software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.CUSTOM_PAYLOAD
  }
  case object ImageResponseCard
      extends zio.aws.lexruntimev2.model.MessageContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType =
      software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.IMAGE_RESPONSE_CARD
  }
  case object PlainText extends zio.aws.lexruntimev2.model.MessageContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType =
      software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.PLAIN_TEXT
  }
  case object SSML extends zio.aws.lexruntimev2.model.MessageContentType {
    override def unwrap
        : software.amazon.awssdk.services.lexruntimev2.model.MessageContentType =
      software.amazon.awssdk.services.lexruntimev2.model.MessageContentType.SSML
  }
}
