package zio.aws.lexruntimev2.model
import zio.aws.lexruntimev2.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SessionState(
    dialogAction: Option[zio.aws.lexruntimev2.model.DialogAction] = None,
    intent: Option[zio.aws.lexruntimev2.model.Intent] = None,
    activeContexts: Option[Iterable[zio.aws.lexruntimev2.model.ActiveContext]] =
      None,
    sessionAttributes: Option[Map[NonEmptyString, String]] = None,
    originatingRequestId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntimev2.model.SessionState = {
    import SessionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntimev2.model.SessionState
      .builder()
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(intent.map(value => value.buildAwsValue()))(_.intent)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString
                .unwrap(key): java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        originatingRequestId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.originatingRequestId)
      .build()
  }
  def asReadOnly: zio.aws.lexruntimev2.model.SessionState.ReadOnly =
    zio.aws.lexruntimev2.model.SessionState.wrap(buildAwsValue())
}
object SessionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntimev2.model.SessionState =
      zio.aws.lexruntimev2.model.SessionState(
        dialogAction.map(value => value.asEditable),
        intent.map(value => value.asEditable),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sessionAttributes.map(value => value),
        originatingRequestId.map(value => value)
      )
    def dialogAction: Option[zio.aws.lexruntimev2.model.DialogAction.ReadOnly]
    def intent: Option[zio.aws.lexruntimev2.model.Intent.ReadOnly]
    def activeContexts
        : Option[List[zio.aws.lexruntimev2.model.ActiveContext.ReadOnly]]
    def sessionAttributes: Option[Map[NonEmptyString, String]]
    def originatingRequestId: Option[NonEmptyString]
    def getDialogAction
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.DialogAction.ReadOnly] =
      AwsError.unwrapOptionField("dialogAction", dialogAction)
    def getIntent
        : ZIO[Any, AwsError, zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      AwsError.unwrapOptionField("intent", intent)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntimev2.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
    def getSessionAttributes: ZIO[Any, AwsError, Map[NonEmptyString, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getOriginatingRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originatingRequestId", originatingRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ) extends zio.aws.lexruntimev2.model.SessionState.ReadOnly {
    override val dialogAction
        : Option[zio.aws.lexruntimev2.model.DialogAction.ReadOnly] = scala
      .Option(impl.dialogAction())
      .map(value => zio.aws.lexruntimev2.model.DialogAction.wrap(value))
    override val intent: Option[zio.aws.lexruntimev2.model.Intent.ReadOnly] =
      scala
        .Option(impl.intent())
        .map(value => zio.aws.lexruntimev2.model.Intent.wrap(value))
    override val activeContexts
        : Option[List[zio.aws.lexruntimev2.model.ActiveContext.ReadOnly]] =
      scala
        .Option(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntimev2.model.ActiveContext.wrap(item)
          }.toList
        )
    override val sessionAttributes: Option[Map[NonEmptyString, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.lexruntimev2.model.primitives
              .NonEmptyString(key) -> (value: String)
          })
          .toMap
      )
    override val originatingRequestId: Option[NonEmptyString] = scala
      .Option(impl.originatingRequestId())
      .map(value => zio.aws.lexruntimev2.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntimev2.model.SessionState
  ): zio.aws.lexruntimev2.model.SessionState.ReadOnly = new Wrapper(impl)
}
