package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{Text, UserId, BotAlias, BotName}
import scala.jdk.CollectionConverters._
final case class PostTextRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Optional[Map[String, String]] = Optional.Absent,
    requestAttributes: Optional[Map[String, String]] = Optional.Absent,
    inputText: Text,
    activeContexts: Optional[Iterable[zio.aws.lexruntime.model.ActiveContext]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostTextRequest = {
    import PostTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextRequest
      .builder()
      .botName(BotName.unwrap(botName): java.lang.String)
      .botAlias(BotAlias.unwrap(botAlias): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        requestAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.requestAttributes)
      .inputText(Text.unwrap(inputText): java.lang.String)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PostTextRequest.ReadOnly =
    zio.aws.lexruntime.model.PostTextRequest.wrap(buildAwsValue())
}
object PostTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PostTextRequest =
      zio.aws.lexruntime.model.PostTextRequest(
        botName,
        botAlias,
        userId,
        sessionAttributes.map(value => value),
        requestAttributes.map(value => value),
        inputText,
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botName: BotName
    def botAlias: BotAlias
    def userId: UserId
    def sessionAttributes: Optional[Map[String, String]]
    def requestAttributes: Optional[Map[String, String]]
    def inputText: Text
    def activeContexts
        : Optional[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]]
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getBotAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAlias)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getSessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getRequestAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("requestAttributes", requestAttributes)
    def getInputText: ZIO[Any, Nothing, Text] = ZIO.succeed(inputText)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ) extends zio.aws.lexruntime.model.PostTextRequest.ReadOnly {
    override val botName: BotName =
      zio.aws.lexruntime.model.primitives.BotName(impl.botName())
    override val botAlias: BotAlias =
      zio.aws.lexruntime.model.primitives.BotAlias(impl.botAlias())
    override val userId: UserId =
      zio.aws.lexruntime.model.primitives.UserId(impl.userId())
    override val sessionAttributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val requestAttributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestAttributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val inputText: Text =
      zio.aws.lexruntime.model.primitives.Text(impl.inputText())
    override val activeContexts
        : Optional[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeContexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.ActiveContext.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextRequest
  ): zio.aws.lexruntime.model.PostTextRequest.ReadOnly = new Wrapper(impl)
}
