package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lexruntime.model.primitives.{
  Text,
  ParameterName,
  ActiveContextName
}
import scala.jdk.CollectionConverters._
final case class ActiveContext(
    name: ActiveContextName,
    timeToLive: zio.aws.lexruntime.model.ActiveContextTimeToLive,
    parameters: Map[ParameterName, Text]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ActiveContext = {
    import ActiveContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ActiveContext
      .builder()
      .name(ActiveContextName.unwrap(name): java.lang.String)
      .timeToLive(timeToLive.buildAwsValue())
      .parameters(
        parameters
          .map({ case (key, value) =>
            (ParameterName.unwrap(key): java.lang.String) -> (Text
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.ActiveContext.ReadOnly =
    zio.aws.lexruntime.model.ActiveContext.wrap(buildAwsValue())
}
object ActiveContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.ActiveContext =
      zio.aws.lexruntime.model
        .ActiveContext(name, timeToLive.asEditable, parameters)
    def name: ActiveContextName
    def timeToLive: zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly
    def parameters: Map[ParameterName, Text]
    def getName: ZIO[Any, Nothing, ActiveContextName] = ZIO.succeed(name)
    def getTimeToLive: ZIO[
      Any,
      Nothing,
      zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly
    ] = ZIO.succeed(timeToLive)
    def getParameters: ZIO[Any, Nothing, Map[ParameterName, Text]] =
      ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ) extends zio.aws.lexruntime.model.ActiveContext.ReadOnly {
    override val name: ActiveContextName =
      zio.aws.lexruntime.model.primitives.ActiveContextName(impl.name())
    override val timeToLive
        : zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly =
      zio.aws.lexruntime.model.ActiveContextTimeToLive.wrap(impl.timeToLive())
    override val parameters: Map[ParameterName, Text] = impl
      .parameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.lexruntime.model.primitives
          .ParameterName(key) -> zio.aws.lexruntime.model.primitives.Text(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContext
  ): zio.aws.lexruntime.model.ActiveContext.ReadOnly = new Wrapper(impl)
}
