package zio.aws.lexruntime
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.lexruntime.LexRuntimeAsyncClient
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.lexruntime.model.{
  PostContentRequest,
  DeleteSessionRequest,
  GetSessionRequest,
  PutSessionRequest,
  PostTextRequest
}
import zio.stream.ZStream
object LexRuntimeMock extends Mock[LexRuntime] {
  object DeleteSession extends Effect[DeleteSessionRequest, AwsError, ReadOnly]
  object PostText
      extends Effect[
        PostTextRequest,
        AwsError,
        zio.aws.lexruntime.model.PostTextResponse.ReadOnly
      ]
  object PostContent
      extends Effect[
        Tuple2[PostContentRequest, ZStream[Any, AwsError, Byte]],
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.lexruntime.model.PostContentResponse.ReadOnly,
          Byte
        ]
      ]
  object PutSession
      extends Effect[PutSessionRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.lexruntime.model.PutSessionResponse.ReadOnly,
        Byte
      ]]
  object GetSession
      extends Effect[
        GetSessionRequest,
        AwsError,
        zio.aws.lexruntime.model.GetSessionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, LexRuntime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, LexRuntime] { rts =>
        zio.ZIO.succeed {
          new LexRuntime {
            val api: LexRuntimeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): LexRuntime = this
            def deleteSession(
                request: DeleteSessionRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteSession, request)
            def postText(request: PostTextRequest): IO[
              AwsError,
              zio.aws.lexruntime.model.PostTextResponse.ReadOnly
            ] = proxy(PostText, request)
            def postContent(
                request: PostContentRequest,
                body: ZStream[Any, AwsError, Byte]
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.lexruntime.model.PostContentResponse.ReadOnly,
              Byte
            ]] = proxy(PostContent, request, body)
            def putSession(
                request: PutSessionRequest
            ): IO[AwsError, StreamingOutputResult[
              Any,
              zio.aws.lexruntime.model.PutSessionResponse.ReadOnly,
              Byte
            ]] = proxy(PutSession, request)
            def getSession(request: GetSessionRequest): IO[
              AwsError,
              zio.aws.lexruntime.model.GetSessionResponse.ReadOnly
            ] = proxy(GetSession, request)
          }
        }
      }
    }
  }
}
