package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.lexruntime.model.primitives.{
  ButtonValueStringWithLength,
  ButtonTextStringWithLength
}
import scala.jdk.CollectionConverters._
final case class Button(
    text: ButtonTextStringWithLength,
    value: ButtonValueStringWithLength
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.Button = {
    import Button.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.Button
      .builder()
      .text(ButtonTextStringWithLength.unwrap(text): java.lang.String)
      .value(ButtonValueStringWithLength.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.Button.ReadOnly =
    zio.aws.lexruntime.model.Button.wrap(buildAwsValue())
}
object Button {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lexruntime.model.Button] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.Button =
      zio.aws.lexruntime.model.Button(text, value)
    def text: ButtonTextStringWithLength
    def value: ButtonValueStringWithLength
    def getText: ZIO[Any, Nothing, ButtonTextStringWithLength] =
      ZIO.succeed(text)
    def getValue: ZIO[Any, Nothing, ButtonValueStringWithLength] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.Button
  ) extends zio.aws.lexruntime.model.Button.ReadOnly {
    override val text: ButtonTextStringWithLength =
      zio.aws.lexruntime.model.primitives
        .ButtonTextStringWithLength(impl.text())
    override val value: ButtonValueStringWithLength =
      zio.aws.lexruntime.model.primitives
        .ButtonValueStringWithLength(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.Button
  ): zio.aws.lexruntime.model.Button.ReadOnly = new Wrapper(impl)
}
