package zio.aws.lexruntime.model
import scala.jdk.CollectionConverters._
sealed trait DialogState {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.DialogState
}
object DialogState {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.DialogState
  ): zio.aws.lexruntime.model.DialogState = value match {
    case software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT =>
      val r = ElicitIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT =>
      val r = ConfirmIntent
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT =>
      val r = ElicitSlot
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
    case software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.UNKNOWN_TO_SDK_VERSION
  }
  case object ElicitIntent extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_INTENT
  }
  case object ConfirmIntent extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.CONFIRM_INTENT
  }
  case object ElicitSlot extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.ELICIT_SLOT
  }
  case object Fulfilled extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.FULFILLED
  }
  case object ReadyForFulfillment extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.READY_FOR_FULFILLMENT
  }
  case object Failed extends zio.aws.lexruntime.model.DialogState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.DialogState =
      software.amazon.awssdk.services.lexruntime.model.DialogState.FAILED
  }
}
