package zio.aws.lexruntime.model
import zio.aws.lexruntime.model.primitives.{
  ActiveContextTurnsToLive,
  ActiveContextTimeToLiveInSeconds
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ActiveContextTimeToLive(
    timeToLiveInSeconds: Optional[ActiveContextTimeToLiveInSeconds] =
      Optional.Absent,
    turnsToLive: Optional[ActiveContextTurnsToLive] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive = {
    import ActiveContextTimeToLive.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
      .builder()
      .optionallyWith(
        timeToLiveInSeconds.map(value =>
          ActiveContextTimeToLiveInSeconds.unwrap(value): Integer
        )
      )(_.timeToLiveInSeconds)
      .optionallyWith(
        turnsToLive.map(value =>
          ActiveContextTurnsToLive.unwrap(value): Integer
        )
      )(_.turnsToLive)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly =
    zio.aws.lexruntime.model.ActiveContextTimeToLive.wrap(buildAwsValue())
}
object ActiveContextTimeToLive {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.ActiveContextTimeToLive =
      zio.aws.lexruntime.model.ActiveContextTimeToLive(
        timeToLiveInSeconds.map(value => value),
        turnsToLive.map(value => value)
      )
    def timeToLiveInSeconds: Optional[ActiveContextTimeToLiveInSeconds]
    def turnsToLive: Optional[ActiveContextTurnsToLive]
    def getTimeToLiveInSeconds
        : ZIO[Any, AwsError, ActiveContextTimeToLiveInSeconds] =
      AwsError.unwrapOptionField("timeToLiveInSeconds", timeToLiveInSeconds)
    def getTurnsToLive: ZIO[Any, AwsError, ActiveContextTurnsToLive] =
      AwsError.unwrapOptionField("turnsToLive", turnsToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ) extends zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly {
    override val timeToLiveInSeconds
        : Optional[ActiveContextTimeToLiveInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLiveInSeconds())
      .map(value =>
        zio.aws.lexruntime.model.primitives
          .ActiveContextTimeToLiveInSeconds(value)
      )
    override val turnsToLive: Optional[ActiveContextTurnsToLive] =
      zio.aws.core.internal
        .optionalFromNullable(impl.turnsToLive())
        .map(value =>
          zio.aws.lexruntime.model.primitives.ActiveContextTurnsToLive(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ActiveContextTimeToLive
  ): zio.aws.lexruntime.model.ActiveContextTimeToLive.ReadOnly = new Wrapper(
    impl
  )
}
