package zio.aws.lexruntime
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.lexruntime.model.primitives.{Text, ParameterName}
import zio.aws.lexruntime.model.primitives.BotVersion.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Accept extends Subtype[String]
    type Accept = zio.aws.lexruntime.model.primitives.Accept.Type
    object ActiveContextName extends Subtype[String]
    type ActiveContextName =
      zio.aws.lexruntime.model.primitives.ActiveContextName.Type
    object ActiveContextTimeToLiveInSeconds extends Subtype[Int]
    type ActiveContextTimeToLiveInSeconds =
      zio.aws.lexruntime.model.primitives.ActiveContextTimeToLiveInSeconds.Type
    object ActiveContextTurnsToLive extends Subtype[Int]
    type ActiveContextTurnsToLive =
      zio.aws.lexruntime.model.primitives.ActiveContextTurnsToLive.Type
    object ActiveContextsString extends Subtype[String]
    type ActiveContextsString =
      zio.aws.lexruntime.model.primitives.ActiveContextsString.Type
    object AttributesString extends Subtype[String]
    type AttributesString =
      zio.aws.lexruntime.model.primitives.AttributesString.Type
    object BlobStream extends Subtype[Chunk[Byte]]
    type BlobStream = zio.aws.lexruntime.model.primitives.BlobStream.Type
    object BotAlias extends Subtype[String]
    type BotAlias = zio.aws.lexruntime.model.primitives.BotAlias.Type
    object BotName extends Subtype[String]
    type BotName = zio.aws.lexruntime.model.primitives.BotName.Type
    object BotVersion extends Subtype[String]
    type BotVersion = zio.aws.lexruntime.model.primitives.BotVersion.Type
    object ButtonTextStringWithLength extends Subtype[String]
    type ButtonTextStringWithLength =
      zio.aws.lexruntime.model.primitives.ButtonTextStringWithLength.Type
    object ButtonValueStringWithLength extends Subtype[String]
    type ButtonValueStringWithLength =
      zio.aws.lexruntime.model.primitives.ButtonValueStringWithLength.Type
    object HttpContentType extends Subtype[String]
    type HttpContentType =
      zio.aws.lexruntime.model.primitives.HttpContentType.Type
    object IntentName extends Subtype[String]
    type IntentName = zio.aws.lexruntime.model.primitives.IntentName.Type
    object IntentSummaryCheckpointLabel extends Subtype[String]
    type IntentSummaryCheckpointLabel =
      zio.aws.lexruntime.model.primitives.IntentSummaryCheckpointLabel.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.lexruntime.model.primitives.ParameterName.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString =
      zio.aws.lexruntime.model.primitives.SensitiveString.Type
    object SensitiveStringUnbounded extends Subtype[String]
    type SensitiveStringUnbounded =
      zio.aws.lexruntime.model.primitives.SensitiveStringUnbounded.Type
    object SentimentLabel extends Subtype[String]
    type SentimentLabel =
      zio.aws.lexruntime.model.primitives.SentimentLabel.Type
    object SentimentScore extends Subtype[String]
    type SentimentScore =
      zio.aws.lexruntime.model.primitives.SentimentScore.Type
    object StringUrlWithLength extends Subtype[String]
    type StringUrlWithLength =
      zio.aws.lexruntime.model.primitives.StringUrlWithLength.Type
    object StringWithLength extends Subtype[String]
    type StringWithLength =
      zio.aws.lexruntime.model.primitives.StringWithLength.Type
    object Text extends Subtype[String]
    type Text = zio.aws.lexruntime.model.primitives.Text.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.lexruntime.model.primitives.UserId.Type
  }
  type ActiveContextParametersMap = Map[ParameterName, Text]
  type ActiveContextsList = List[zio.aws.lexruntime.model.ActiveContext]
  type GenericAttachmentList = List[zio.aws.lexruntime.model.GenericAttachment]
  type IntentList = List[zio.aws.lexruntime.model.PredictedIntent]
  type IntentSummaryList = List[zio.aws.lexruntime.model.IntentSummary]
  type ListOfButtons = List[zio.aws.lexruntime.model.Button]
  type StringMap = Map[String, String]
}
