package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.lexruntime.model.primitives.{UserId, BotAlias, BotName}
import scala.jdk.CollectionConverters._
final case class DeleteSessionResponse(
    botName: Optional[BotName] = Optional.Absent,
    botAlias: Optional[BotAlias] = Optional.Absent,
    userId: Optional[UserId] = Optional.Absent,
    sessionId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse = {
    import DeleteSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
      .builder()
      .optionallyWith(
        botName.map(value => BotName.unwrap(value): java.lang.String)
      )(_.botName)
      .optionallyWith(
        botAlias.map(value => BotAlias.unwrap(value): java.lang.String)
      )(_.botAlias)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly =
    zio.aws.lexruntime.model.DeleteSessionResponse.wrap(buildAwsValue())
}
object DeleteSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.DeleteSessionResponse =
      zio.aws.lexruntime.model.DeleteSessionResponse(
        botName.map(value => value),
        botAlias.map(value => value),
        userId.map(value => value),
        sessionId.map(value => value)
      )
    def botName: Optional[BotName]
    def botAlias: Optional[BotAlias]
    def userId: Optional[UserId]
    def sessionId: Optional[String]
    def getBotName: ZIO[Any, AwsError, BotName] =
      AwsError.unwrapOptionField("botName", botName)
    def getBotAlias: ZIO[Any, AwsError, BotAlias] =
      AwsError.unwrapOptionField("botAlias", botAlias)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ) extends zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly {
    override val botName: Optional[BotName] = zio.aws.core.internal
      .optionalFromNullable(impl.botName())
      .map(value => zio.aws.lexruntime.model.primitives.BotName(value))
    override val botAlias: Optional[BotAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.botAlias())
      .map(value => zio.aws.lexruntime.model.primitives.BotAlias(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.lexruntime.model.primitives.UserId(value))
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.DeleteSessionResponse
  ): zio.aws.lexruntime.model.DeleteSessionResponse.ReadOnly = new Wrapper(impl)
}
