package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{SentimentScore, SentimentLabel}
import scala.jdk.CollectionConverters._
final case class SentimentResponse(
    sentimentLabel: Option[SentimentLabel] = None,
    sentimentScore: Option[SentimentScore] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.SentimentResponse = {
    import SentimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.SentimentResponse
      .builder()
      .optionallyWith(
        sentimentLabel.map(value =>
          SentimentLabel.unwrap(value): java.lang.String
        )
      )(_.sentimentLabel)
      .optionallyWith(
        sentimentScore.map(value =>
          SentimentScore.unwrap(value): java.lang.String
        )
      )(_.sentimentScore)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.SentimentResponse.ReadOnly =
    zio.aws.lexruntime.model.SentimentResponse.wrap(buildAwsValue())
}
object SentimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.SentimentResponse =
      zio.aws.lexruntime.model.SentimentResponse(
        sentimentLabel.map(value => value),
        sentimentScore.map(value => value)
      )
    def sentimentLabel: Option[SentimentLabel]
    def sentimentScore: Option[SentimentScore]
    def getSentimentLabel: ZIO[Any, AwsError, SentimentLabel] =
      AwsError.unwrapOptionField("sentimentLabel", sentimentLabel)
    def getSentimentScore: ZIO[Any, AwsError, SentimentScore] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ) extends zio.aws.lexruntime.model.SentimentResponse.ReadOnly {
    override val sentimentLabel: Option[SentimentLabel] = scala
      .Option(impl.sentimentLabel())
      .map(value => zio.aws.lexruntime.model.primitives.SentimentLabel(value))
    override val sentimentScore: Option[SentimentScore] = scala
      .Option(impl.sentimentScore())
      .map(value => zio.aws.lexruntime.model.primitives.SentimentScore(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.SentimentResponse
  ): zio.aws.lexruntime.model.SentimentResponse.ReadOnly = new Wrapper(impl)
}
