package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseCard(
    version: Option[String] = None,
    contentType: Option[zio.aws.lexruntime.model.ContentType] = None,
    genericAttachments: Option[
      Iterable[zio.aws.lexruntime.model.GenericAttachment]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.ResponseCard = {
    import ResponseCard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.ResponseCard
      .builder()
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(
        genericAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.genericAttachments)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.ResponseCard.ReadOnly =
    zio.aws.lexruntime.model.ResponseCard.wrap(buildAwsValue())
}
object ResponseCard {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.ResponseCard =
      zio.aws.lexruntime.model.ResponseCard(
        version.map(value => value),
        contentType.map(value => value),
        genericAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def version: Option[String]
    def contentType: Option[zio.aws.lexruntime.model.ContentType]
    def genericAttachments
        : Option[List[zio.aws.lexruntime.model.GenericAttachment.ReadOnly]]
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
    def getContentType
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getGenericAttachments: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.GenericAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("genericAttachments", genericAttachments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ) extends zio.aws.lexruntime.model.ResponseCard.ReadOnly {
    override val version: Option[String] =
      scala.Option(impl.version()).map(value => value: String)
    override val contentType: Option[zio.aws.lexruntime.model.ContentType] =
      scala
        .Option(impl.contentType())
        .map(value => zio.aws.lexruntime.model.ContentType.wrap(value))
    override val genericAttachments
        : Option[List[zio.aws.lexruntime.model.GenericAttachment.ReadOnly]] =
      scala
        .Option(impl.genericAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.GenericAttachment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.ResponseCard
  ): zio.aws.lexruntime.model.ResponseCard.ReadOnly = new Wrapper(impl)
}
