package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{
  HttpContentType,
  Text,
  IntentName,
  ActiveContextsString,
  SensitiveString
}
import scala.jdk.CollectionConverters._
final case class PutSessionResponse(
    contentType: Option[HttpContentType] = None,
    intentName: Option[IntentName] = None,
    slots: Option[String] = None,
    sessionAttributes: Option[String] = None,
    message: Option[Text] = None,
    encodedMessage: Option[SensitiveString] = None,
    messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType] = None,
    dialogState: Option[zio.aws.lexruntime.model.DialogState] = None,
    slotToElicit: Option[String] = None,
    sessionId: Option[String] = None,
    activeContexts: Option[ActiveContextsString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PutSessionResponse = {
    import PutSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
      .builder()
      .optionallyWith(
        contentType.map(value =>
          HttpContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(slots.map(value => value: java.lang.String))(_.slots)
      .optionallyWith(sessionAttributes.map(value => value: java.lang.String))(
        _.sessionAttributes
      )
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        encodedMessage.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.encodedMessage)
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(
        activeContexts.map(value =>
          ActiveContextsString.unwrap(value): java.lang.String
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PutSessionResponse.ReadOnly =
    zio.aws.lexruntime.model.PutSessionResponse.wrap(buildAwsValue())
}
object PutSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PutSessionResponse =
      zio.aws.lexruntime.model.PutSessionResponse(
        contentType.map(value => value),
        intentName.map(value => value),
        slots.map(value => value),
        sessionAttributes.map(value => value),
        message.map(value => value),
        encodedMessage.map(value => value),
        messageFormat.map(value => value),
        dialogState.map(value => value),
        slotToElicit.map(value => value),
        sessionId.map(value => value),
        activeContexts.map(value => value)
      )
    def contentType: Option[HttpContentType]
    def intentName: Option[IntentName]
    def slots: Option[String]
    def sessionAttributes: Option[String]
    def message: Option[Text]
    def encodedMessage: Option[SensitiveString]
    def messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType]
    def dialogState: Option[zio.aws.lexruntime.model.DialogState]
    def slotToElicit: Option[String]
    def sessionId: Option[String]
    def activeContexts: Option[ActiveContextsString]
    def getContentType: ZIO[Any, AwsError, HttpContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getSlots: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slots", slots)
    def getSessionAttributes: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getEncodedMessage: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("encodedMessage", encodedMessage)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getDialogState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogState] =
      AwsError.unwrapOptionField("dialogState", dialogState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getActiveContexts: ZIO[Any, AwsError, ActiveContextsString] =
      AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ) extends zio.aws.lexruntime.model.PutSessionResponse.ReadOnly {
    override val contentType: Option[HttpContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.lexruntime.model.primitives.HttpContentType(value))
    override val intentName: Option[IntentName] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val slots: Option[String] =
      scala.Option(impl.slots()).map(value => value: String)
    override val sessionAttributes: Option[String] =
      scala.Option(impl.sessionAttributes()).map(value => value: String)
    override val message: Option[Text] = scala
      .Option(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val encodedMessage: Option[SensitiveString] = scala
      .Option(impl.encodedMessage())
      .map(value => zio.aws.lexruntime.model.primitives.SensitiveString(value))
    override val messageFormat
        : Option[zio.aws.lexruntime.model.MessageFormatType] = scala
      .Option(impl.messageFormat())
      .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
    override val dialogState: Option[zio.aws.lexruntime.model.DialogState] =
      scala
        .Option(impl.dialogState())
        .map(value => zio.aws.lexruntime.model.DialogState.wrap(value))
    override val slotToElicit: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override val sessionId: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override val activeContexts: Option[ActiveContextsString] = scala
      .Option(impl.activeContexts())
      .map(value =>
        zio.aws.lexruntime.model.primitives.ActiveContextsString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionResponse
  ): zio.aws.lexruntime.model.PutSessionResponse.ReadOnly = new Wrapper(impl)
}
