package zio.aws.lexruntime.model
import scala.jdk.CollectionConverters._
sealed trait FulfillmentState {
  def unwrap: software.amazon.awssdk.services.lexruntime.model.FulfillmentState
}
object FulfillmentState {
  def wrap(
      value: software.amazon.awssdk.services.lexruntime.model.FulfillmentState
  ): zio.aws.lexruntime.model.FulfillmentState = value match {
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED =>
      val r = Fulfilled
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT =>
      val r = ReadyForFulfillment
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object Fulfilled extends zio.aws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FULFILLED
  }
  case object Failed extends zio.aws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.FAILED
  }
  case object ReadyForFulfillment
      extends zio.aws.lexruntime.model.FulfillmentState {
    override def unwrap
        : software.amazon.awssdk.services.lexruntime.model.FulfillmentState =
      software.amazon.awssdk.services.lexruntime.model.FulfillmentState.READY_FOR_FULFILLMENT
  }
}
