package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{BotVersion, Text, IntentName}
import scala.jdk.CollectionConverters._
final case class PostTextResponse(
    intentName: Option[IntentName] = None,
    nluIntentConfidence: Option[zio.aws.lexruntime.model.IntentConfidence] =
      None,
    alternativeIntents: Option[
      Iterable[zio.aws.lexruntime.model.PredictedIntent]
    ] = None,
    slots: Option[Map[String, String]] = None,
    sessionAttributes: Option[Map[String, String]] = None,
    message: Option[Text] = None,
    sentimentResponse: Option[zio.aws.lexruntime.model.SentimentResponse] =
      None,
    messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType] = None,
    dialogState: Option[zio.aws.lexruntime.model.DialogState] = None,
    slotToElicit: Option[String] = None,
    responseCard: Option[zio.aws.lexruntime.model.ResponseCard] = None,
    sessionId: Option[String] = None,
    botVersion: Option[BotVersion] = None,
    activeContexts: Option[Iterable[zio.aws.lexruntime.model.ActiveContext]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PostTextResponse = {
    import PostTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
      .builder()
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(
        _.nluIntentConfidence
      )
      .optionallyWith(
        alternativeIntents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternativeIntents)
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(
        message.map(value => Text.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(sentimentResponse.map(value => value.buildAwsValue()))(
        _.sentimentResponse
      )
      .optionallyWith(messageFormat.map(value => value.unwrap))(_.messageFormat)
      .optionallyWith(dialogState.map(value => value.unwrap))(_.dialogState)
      .optionallyWith(slotToElicit.map(value => value: java.lang.String))(
        _.slotToElicit
      )
      .optionallyWith(responseCard.map(value => value.buildAwsValue()))(
        _.responseCard
      )
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(
        botVersion.map(value => BotVersion.unwrap(value): java.lang.String)
      )(_.botVersion)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PostTextResponse.ReadOnly =
    zio.aws.lexruntime.model.PostTextResponse.wrap(buildAwsValue())
}
object PostTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PostTextResponse =
      zio.aws.lexruntime.model.PostTextResponse(
        intentName.map(value => value),
        nluIntentConfidence.map(value => value.asEditable),
        alternativeIntents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        slots.map(value => value),
        sessionAttributes.map(value => value),
        message.map(value => value),
        sentimentResponse.map(value => value.asEditable),
        messageFormat.map(value => value),
        dialogState.map(value => value),
        slotToElicit.map(value => value),
        responseCard.map(value => value.asEditable),
        sessionId.map(value => value),
        botVersion.map(value => value),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def intentName: Option[IntentName]
    def nluIntentConfidence
        : Option[zio.aws.lexruntime.model.IntentConfidence.ReadOnly]
    def alternativeIntents
        : Option[List[zio.aws.lexruntime.model.PredictedIntent.ReadOnly]]
    def slots: Option[Map[String, String]]
    def sessionAttributes: Option[Map[String, String]]
    def message: Option[Text]
    def sentimentResponse
        : Option[zio.aws.lexruntime.model.SentimentResponse.ReadOnly]
    def messageFormat: Option[zio.aws.lexruntime.model.MessageFormatType]
    def dialogState: Option[zio.aws.lexruntime.model.DialogState]
    def slotToElicit: Option[String]
    def responseCard: Option[zio.aws.lexruntime.model.ResponseCard.ReadOnly]
    def sessionId: Option[String]
    def botVersion: Option[BotVersion]
    def activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]]
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getNluIntentConfidence: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntime.model.IntentConfidence.ReadOnly
    ] = AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidence)
    def getAlternativeIntents: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.PredictedIntent.ReadOnly
    ]] = AwsError.unwrapOptionField("alternativeIntents", alternativeIntents)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
    def getSessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getMessage: ZIO[Any, AwsError, Text] =
      AwsError.unwrapOptionField("message", message)
    def getSentimentResponse: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntime.model.SentimentResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sentimentResponse", sentimentResponse)
    def getMessageFormat
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.MessageFormatType] =
      AwsError.unwrapOptionField("messageFormat", messageFormat)
    def getDialogState
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogState] =
      AwsError.unwrapOptionField("dialogState", dialogState)
    def getSlotToElicit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotToElicit", slotToElicit)
    def getResponseCard
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.ResponseCard.ReadOnly] =
      AwsError.unwrapOptionField("responseCard", responseCard)
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getBotVersion: ZIO[Any, AwsError, BotVersion] =
      AwsError.unwrapOptionField("botVersion", botVersion)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ) extends zio.aws.lexruntime.model.PostTextResponse.ReadOnly {
    override val intentName: Option[IntentName] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val nluIntentConfidence
        : Option[zio.aws.lexruntime.model.IntentConfidence.ReadOnly] = scala
      .Option(impl.nluIntentConfidence())
      .map(value => zio.aws.lexruntime.model.IntentConfidence.wrap(value))
    override val alternativeIntents
        : Option[List[zio.aws.lexruntime.model.PredictedIntent.ReadOnly]] =
      scala
        .Option(impl.alternativeIntents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lexruntime.model.PredictedIntent.wrap(item)
          }.toList
        )
    override val slots: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val sessionAttributes: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val message: Option[Text] = scala
      .Option(impl.message())
      .map(value => zio.aws.lexruntime.model.primitives.Text(value))
    override val sentimentResponse
        : Option[zio.aws.lexruntime.model.SentimentResponse.ReadOnly] = scala
      .Option(impl.sentimentResponse())
      .map(value => zio.aws.lexruntime.model.SentimentResponse.wrap(value))
    override val messageFormat
        : Option[zio.aws.lexruntime.model.MessageFormatType] = scala
      .Option(impl.messageFormat())
      .map(value => zio.aws.lexruntime.model.MessageFormatType.wrap(value))
    override val dialogState: Option[zio.aws.lexruntime.model.DialogState] =
      scala
        .Option(impl.dialogState())
        .map(value => zio.aws.lexruntime.model.DialogState.wrap(value))
    override val slotToElicit: Option[String] =
      scala.Option(impl.slotToElicit()).map(value => value: String)
    override val responseCard
        : Option[zio.aws.lexruntime.model.ResponseCard.ReadOnly] = scala
      .Option(impl.responseCard())
      .map(value => zio.aws.lexruntime.model.ResponseCard.wrap(value))
    override val sessionId: Option[String] =
      scala.Option(impl.sessionId()).map(value => value: String)
    override val botVersion: Option[BotVersion] = scala
      .Option(impl.botVersion())
      .map(value => zio.aws.lexruntime.model.primitives.BotVersion(value))
    override val activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PostTextResponse
  ): zio.aws.lexruntime.model.PostTextResponse.ReadOnly = new Wrapper(impl)
}
