package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.{Accept, UserId, BotAlias, BotName}
import scala.jdk.CollectionConverters._
final case class PutSessionRequest(
    botName: BotName,
    botAlias: BotAlias,
    userId: UserId,
    sessionAttributes: Option[Map[String, String]] = None,
    dialogAction: Option[zio.aws.lexruntime.model.DialogAction] = None,
    recentIntentSummaryView: Option[
      Iterable[zio.aws.lexruntime.model.IntentSummary]
    ] = None,
    accept: Option[Accept] = None,
    activeContexts: Option[Iterable[zio.aws.lexruntime.model.ActiveContext]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PutSessionRequest = {
    import PutSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
      .builder()
      .botName(BotName.unwrap(botName): java.lang.String)
      .botAlias(BotAlias.unwrap(botAlias): java.lang.String)
      .userId(UserId.unwrap(userId): java.lang.String)
      .optionallyWith(
        sessionAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.sessionAttributes)
      .optionallyWith(dialogAction.map(value => value.buildAwsValue()))(
        _.dialogAction
      )
      .optionallyWith(
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recentIntentSummaryView)
      .optionallyWith(
        accept.map(value => Accept.unwrap(value): java.lang.String)
      )(_.accept)
      .optionallyWith(
        activeContexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeContexts)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PutSessionRequest.ReadOnly =
    zio.aws.lexruntime.model.PutSessionRequest.wrap(buildAwsValue())
}
object PutSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PutSessionRequest =
      zio.aws.lexruntime.model.PutSessionRequest(
        botName,
        botAlias,
        userId,
        sessionAttributes.map(value => value),
        dialogAction.map(value => value.asEditable),
        recentIntentSummaryView.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accept.map(value => value),
        activeContexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def botName: BotName
    def botAlias: BotAlias
    def userId: UserId
    def sessionAttributes: Option[Map[String, String]]
    def dialogAction: Option[zio.aws.lexruntime.model.DialogAction.ReadOnly]
    def recentIntentSummaryView
        : Option[List[zio.aws.lexruntime.model.IntentSummary.ReadOnly]]
    def accept: Option[Accept]
    def activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]]
    def getBotName: ZIO[Any, Nothing, BotName] = ZIO.succeed(botName)
    def getBotAlias: ZIO[Any, Nothing, BotAlias] = ZIO.succeed(botAlias)
    def getUserId: ZIO[Any, Nothing, UserId] = ZIO.succeed(userId)
    def getSessionAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("sessionAttributes", sessionAttributes)
    def getDialogAction
        : ZIO[Any, AwsError, zio.aws.lexruntime.model.DialogAction.ReadOnly] =
      AwsError.unwrapOptionField("dialogAction", dialogAction)
    def getRecentIntentSummaryView: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.IntentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "recentIntentSummaryView",
      recentIntentSummaryView
    )
    def getAccept: ZIO[Any, AwsError, Accept] =
      AwsError.unwrapOptionField("accept", accept)
    def getActiveContexts: ZIO[Any, AwsError, List[
      zio.aws.lexruntime.model.ActiveContext.ReadOnly
    ]] = AwsError.unwrapOptionField("activeContexts", activeContexts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ) extends zio.aws.lexruntime.model.PutSessionRequest.ReadOnly {
    override val botName: BotName =
      zio.aws.lexruntime.model.primitives.BotName(impl.botName())
    override val botAlias: BotAlias =
      zio.aws.lexruntime.model.primitives.BotAlias(impl.botAlias())
    override val userId: UserId =
      zio.aws.lexruntime.model.primitives.UserId(impl.userId())
    override val sessionAttributes: Option[Map[String, String]] = scala
      .Option(impl.sessionAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val dialogAction
        : Option[zio.aws.lexruntime.model.DialogAction.ReadOnly] = scala
      .Option(impl.dialogAction())
      .map(value => zio.aws.lexruntime.model.DialogAction.wrap(value))
    override val recentIntentSummaryView
        : Option[List[zio.aws.lexruntime.model.IntentSummary.ReadOnly]] = scala
      .Option(impl.recentIntentSummaryView())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.IntentSummary.wrap(item)
        }.toList
      )
    override val accept: Option[Accept] = scala
      .Option(impl.accept())
      .map(value => zio.aws.lexruntime.model.primitives.Accept(value))
    override val activeContexts
        : Option[List[zio.aws.lexruntime.model.ActiveContext.ReadOnly]] = scala
      .Option(impl.activeContexts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lexruntime.model.ActiveContext.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PutSessionRequest
  ): zio.aws.lexruntime.model.PutSessionRequest.ReadOnly = new Wrapper(impl)
}
