package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.lexruntime.model.primitives.IntentName
import scala.jdk.CollectionConverters._
final case class PredictedIntent(
    intentName: Option[IntentName] = None,
    nluIntentConfidence: Option[zio.aws.lexruntime.model.IntentConfidence] =
      None,
    slots: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.PredictedIntent = {
    import PredictedIntent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.PredictedIntent
      .builder()
      .optionallyWith(
        intentName.map(value => IntentName.unwrap(value): java.lang.String)
      )(_.intentName)
      .optionallyWith(nluIntentConfidence.map(value => value.buildAwsValue()))(
        _.nluIntentConfidence
      )
      .optionallyWith(
        slots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.slots)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.PredictedIntent.ReadOnly =
    zio.aws.lexruntime.model.PredictedIntent.wrap(buildAwsValue())
}
object PredictedIntent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.PredictedIntent =
      zio.aws.lexruntime.model.PredictedIntent(
        intentName.map(value => value),
        nluIntentConfidence.map(value => value.asEditable),
        slots.map(value => value)
      )
    def intentName: Option[IntentName]
    def nluIntentConfidence
        : Option[zio.aws.lexruntime.model.IntentConfidence.ReadOnly]
    def slots: Option[Map[String, String]]
    def getIntentName: ZIO[Any, AwsError, IntentName] =
      AwsError.unwrapOptionField("intentName", intentName)
    def getNluIntentConfidence: ZIO[
      Any,
      AwsError,
      zio.aws.lexruntime.model.IntentConfidence.ReadOnly
    ] = AwsError.unwrapOptionField("nluIntentConfidence", nluIntentConfidence)
    def getSlots: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("slots", slots)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ) extends zio.aws.lexruntime.model.PredictedIntent.ReadOnly {
    override val intentName: Option[IntentName] = scala
      .Option(impl.intentName())
      .map(value => zio.aws.lexruntime.model.primitives.IntentName(value))
    override val nluIntentConfidence
        : Option[zio.aws.lexruntime.model.IntentConfidence.ReadOnly] = scala
      .Option(impl.nluIntentConfidence())
      .map(value => zio.aws.lexruntime.model.IntentConfidence.wrap(value))
    override val slots: Option[Map[String, String]] = scala
      .Option(impl.slots())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.PredictedIntent
  ): zio.aws.lexruntime.model.PredictedIntent.ReadOnly = new Wrapper(impl)
}
