package zio.aws.lexruntime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IntentConfidence(score: Option[Double] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lexruntime.model.IntentConfidence = {
    import IntentConfidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lexruntime.model.IntentConfidence
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Double))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.lexruntime.model.IntentConfidence.ReadOnly =
    zio.aws.lexruntime.model.IntentConfidence.wrap(buildAwsValue())
}
object IntentConfidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lexruntime.model.IntentConfidence =
      zio.aws.lexruntime.model.IntentConfidence(score.map(value => value))
    def score: Option[Double]
    def getScore: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ) extends zio.aws.lexruntime.model.IntentConfidence.ReadOnly {
    override val score: Option[Double] =
      scala.Option(impl.score()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lexruntime.model.IntentConfidence
  ): zio.aws.lexruntime.model.IntentConfidence.ReadOnly = new Wrapper(impl)
}
